/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ShutdownThread;

public class ShutdownMonitor {
    private final Set<LifeCycle> _lifeCycles = new CopyOnWriteArraySet<LifeCycle>();
    private boolean DEBUG = System.getProperty("DEBUG") != null;
    private String host = System.getProperty("STOP.HOST", "127.0.0.1");
    private int port = Integer.parseInt(System.getProperty("STOP.PORT", "-1"));
    private String key = System.getProperty("STOP.KEY", null);
    private boolean exitVm = true;
    private ServerSocket serverSocket;
    private Thread thread;

    public static ShutdownMonitor getInstance() {
        return Holder.instance;
    }

    public static synchronized void register(LifeCycle ... lifeCycles) {
        ShutdownMonitor.getInstance()._lifeCycles.addAll(Arrays.asList(lifeCycles));
    }

    public static synchronized void deregister(LifeCycle lifeCycle) {
        ShutdownMonitor.getInstance()._lifeCycles.remove(lifeCycle);
    }

    public static synchronized boolean isRegistered(LifeCycle lifeCycle) {
        return ShutdownMonitor.getInstance()._lifeCycles.contains(lifeCycle);
    }

    private ShutdownMonitor() {
    }

    private void close(ServerSocket server) {
        if (server == null) {
            return;
        }
        try {
            server.close();
        }
        catch (IOException ignore) {
            this.debug(ignore);
        }
    }

    private void close(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException ignore) {
            this.debug(ignore);
        }
    }

    private void shutdownInput(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.shutdownInput();
        }
        catch (IOException ignore) {
            this.debug(ignore);
        }
    }

    private void debug(String format, Object ... args) {
        if (this.DEBUG) {
            System.err.printf("[ShutdownMonitor] " + format + "%n", args);
        }
    }

    private void debug(Throwable t) {
        if (this.DEBUG) {
            t.printStackTrace(System.err);
        }
    }

    public String getKey() {
        return this.key;
    }

    public int getPort() {
        return this.port;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public boolean isExitVm() {
        return this.exitVm;
    }

    public void setDebug(boolean flag) {
        this.DEBUG = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExitVm(boolean exitVm) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                throw new IllegalStateException("ShutdownMonitorThread already started");
            }
            this.exitVm = exitVm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(String key) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                throw new IllegalStateException("ShutdownMonitorThread already started");
            }
            this.key = key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int port) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                throw new IllegalStateException("ShutdownMonitorThread already started");
            }
            this.port = port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws Exception {
        Thread t = null;
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                if (this.DEBUG) {
                    System.err.printf("ShutdownMonitorThread already started", new Object[0]);
                }
                return;
            }
            this.thread = new Thread(new ShutdownMonitorRunnable());
            this.thread.setDaemon(true);
            this.thread.setName("ShutdownMonitor");
            t = this.thread;
        }
        if (t != null) {
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAlive() {
        boolean result = false;
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            result = this.thread != null && this.thread.isAlive();
        }
        return result;
    }

    public String toString() {
        return String.format("%s[port=%d]", this.getClass().getName(), this.port);
    }

    private class ShutdownMonitorRunnable
    implements Runnable {
        public ShutdownMonitorRunnable() {
            this.startListenSocket();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ShutdownMonitor.this.serverSocket == null) {
                return;
            }
            while (ShutdownMonitor.this.serverSocket != null) {
                Socket socket = null;
                try {
                    socket = ShutdownMonitor.this.serverSocket.accept();
                    LineNumberReader lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                    String receivedKey = lin.readLine();
                    if (!ShutdownMonitor.this.key.equals(receivedKey)) {
                        System.err.println("Ignoring command with incorrect key");
                        continue;
                    }
                    OutputStream out = socket.getOutputStream();
                    String cmd = lin.readLine();
                    ShutdownMonitor.this.debug("command=%s", new Object[]{cmd});
                    if ("stop".equalsIgnoreCase(cmd)) {
                        ShutdownMonitor.this.debug("Issuing stop...", new Object[0]);
                        for (LifeCycle l : ShutdownMonitor.this._lifeCycles) {
                            try {
                                if (l.isStarted() && ShutdownThread.isRegistered(l)) {
                                    l.stop();
                                }
                                if (!(l instanceof Destroyable) || !ShutdownMonitor.this.exitVm) continue;
                                ((Destroyable)((Object)l)).destroy();
                            }
                            catch (Exception e) {
                                ShutdownMonitor.this.debug(e);
                            }
                        }
                        this.stopInput(socket);
                        ShutdownMonitor.this.debug("Informing client that we are stopped.", new Object[0]);
                        this.informClient(out, "Stopped\r\n");
                        this.stopOutput(socket);
                        if (!ShutdownMonitor.this.exitVm) continue;
                        ShutdownMonitor.this.debug("Killing JVM", new Object[0]);
                        System.exit(0);
                        continue;
                    }
                    if ("forcestop".equalsIgnoreCase(cmd)) {
                        ShutdownMonitor.this.debug("Issuing force stop...", new Object[0]);
                        this.stopLifeCycles(ShutdownMonitor.this.exitVm);
                        this.stopInput(socket);
                        ShutdownMonitor.this.debug("Informing client that we are stopped.", new Object[0]);
                        this.informClient(out, "Stopped\r\n");
                        this.stopOutput(socket);
                        if (!ShutdownMonitor.this.exitVm) continue;
                        ShutdownMonitor.this.debug("Killing JVM", new Object[0]);
                        System.exit(0);
                        continue;
                    }
                    if ("stopexit".equalsIgnoreCase(cmd)) {
                        ShutdownMonitor.this.debug("Issuing stop and exit...", new Object[0]);
                        this.stopLifeCycles(true);
                        this.stopInput(socket);
                        ShutdownMonitor.this.debug("Informing client that we are stopped.", new Object[0]);
                        this.informClient(out, "Stopped\r\n");
                        this.stopOutput(socket);
                        ShutdownMonitor.this.debug("Killing JVM", new Object[0]);
                        System.exit(0);
                        continue;
                    }
                    if ("exit".equalsIgnoreCase(cmd)) {
                        ShutdownMonitor.this.debug("Killing JVM", new Object[0]);
                        System.exit(0);
                        continue;
                    }
                    if (!"status".equalsIgnoreCase(cmd)) continue;
                    this.informClient(out, "OK\r\n");
                }
                catch (Exception e) {
                    ShutdownMonitor.this.debug(e);
                    System.err.println(e.toString());
                }
                finally {
                    ShutdownMonitor.this.close(socket);
                    socket = null;
                }
            }
        }

        public void stopInput(Socket socket) {
            ShutdownMonitor.this.close(ShutdownMonitor.this.serverSocket);
            ShutdownMonitor.this.serverSocket = null;
            ShutdownMonitor.this.shutdownInput(socket);
        }

        public void stopOutput(Socket socket) throws IOException {
            socket.shutdownOutput();
            ShutdownMonitor.this.close(socket);
            socket = null;
            ShutdownMonitor.this.debug("Shutting down monitor", new Object[0]);
            ShutdownMonitor.this.serverSocket = null;
        }

        public void informClient(OutputStream out, String message) throws IOException {
            out.write(message.getBytes(StandardCharsets.UTF_8));
            out.flush();
        }

        public void stopLifeCycles(boolean destroy) {
            for (LifeCycle l : ShutdownMonitor.this._lifeCycles) {
                try {
                    if (l.isStarted()) {
                        l.stop();
                    }
                    if (!(l instanceof Destroyable) || !destroy) continue;
                    ((Destroyable)((Object)l)).destroy();
                }
                catch (Exception e) {
                    ShutdownMonitor.this.debug(e);
                }
            }
        }

        public void startListenSocket() {
            block7: {
                if (ShutdownMonitor.this.port < 0) {
                    if (ShutdownMonitor.this.DEBUG) {
                        System.err.println("ShutdownMonitor not in use (port < 0): " + ShutdownMonitor.this.port);
                    }
                    return;
                }
                try {
                    ShutdownMonitor.this.serverSocket = new ServerSocket();
                    ShutdownMonitor.this.serverSocket.setReuseAddress(true);
                    ShutdownMonitor.this.serverSocket.bind(new InetSocketAddress(InetAddress.getByName(ShutdownMonitor.this.host), ShutdownMonitor.this.port), 1);
                    if (ShutdownMonitor.this.port == 0) {
                        ShutdownMonitor.this.port = ShutdownMonitor.this.serverSocket.getLocalPort();
                        System.out.printf("STOP.PORT=%d%n", ShutdownMonitor.this.port);
                    }
                    if (ShutdownMonitor.this.key != null) break block7;
                    ShutdownMonitor.this.key = Long.toString((long)(9.223372036854776E18 * Math.random() + (double)this.hashCode() + (double)System.currentTimeMillis()), 36);
                    System.out.printf("STOP.KEY=%s%n", ShutdownMonitor.this.key);
                }
                catch (Exception e) {
                    try {
                        ShutdownMonitor.this.debug(e);
                        System.err.println("Error binding monitor port " + ShutdownMonitor.this.port + ": " + e.toString());
                        ShutdownMonitor.this.serverSocket = null;
                    }
                    catch (Throwable throwable) {
                        ShutdownMonitor.this.debug("STOP.PORT=%d", new Object[]{ShutdownMonitor.this.port});
                        ShutdownMonitor.this.debug("STOP.KEY=%s", new Object[]{ShutdownMonitor.this.key});
                        ShutdownMonitor.this.debug("%s", new Object[]{ShutdownMonitor.this.serverSocket});
                        throw throwable;
                    }
                    ShutdownMonitor.this.debug("STOP.PORT=%d", new Object[]{ShutdownMonitor.this.port});
                    ShutdownMonitor.this.debug("STOP.KEY=%s", new Object[]{ShutdownMonitor.this.key});
                    ShutdownMonitor.this.debug("%s", new Object[]{ShutdownMonitor.this.serverSocket});
                }
            }
            ShutdownMonitor.this.debug("STOP.PORT=%d", new Object[]{ShutdownMonitor.this.port});
            ShutdownMonitor.this.debug("STOP.KEY=%s", new Object[]{ShutdownMonitor.this.key});
            ShutdownMonitor.this.debug("%s", new Object[]{ShutdownMonitor.this.serverSocket});
        }
    }

    static class Holder {
        static ShutdownMonitor instance = new ShutdownMonitor();

        Holder() {
        }
    }
}

