/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.deadlocker8.budgetmaster.logic.updater.VersionInformation;
import de.deadlocker8.budgetmasterserver.logic.Settings;
import de.deadlocker8.budgetmasterserver.logic.Utils;
import de.deadlocker8.budgetmasterserver.logic.database.creator.DatabaseCreator;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import de.deadlocker8.budgetmasterserver.server.category.CategoryAdd;
import de.deadlocker8.budgetmasterserver.server.category.CategoryDelete;
import de.deadlocker8.budgetmasterserver.server.category.CategoryGet;
import de.deadlocker8.budgetmasterserver.server.category.CategoryGetAll;
import de.deadlocker8.budgetmasterserver.server.category.CategoryUpdate;
import de.deadlocker8.budgetmasterserver.server.categorybudget.CategoryBudgetGet;
import de.deadlocker8.budgetmasterserver.server.charts.CategoryInOutSumForMonth;
import de.deadlocker8.budgetmasterserver.server.charts.MonthInOutSum;
import de.deadlocker8.budgetmasterserver.server.database.DatabaseDelete;
import de.deadlocker8.budgetmasterserver.server.database.DatabaseExport;
import de.deadlocker8.budgetmasterserver.server.database.DatabaseImport;
import de.deadlocker8.budgetmasterserver.server.info.InformationGet;
import de.deadlocker8.budgetmasterserver.server.info.VersionGet;
import de.deadlocker8.budgetmasterserver.server.log.LogDelete;
import de.deadlocker8.budgetmasterserver.server.payment.normal.PaymentAdd;
import de.deadlocker8.budgetmasterserver.server.payment.normal.PaymentDelete;
import de.deadlocker8.budgetmasterserver.server.payment.normal.PaymentGet;
import de.deadlocker8.budgetmasterserver.server.payment.normal.PaymentUpdate;
import de.deadlocker8.budgetmasterserver.server.payment.repeating.RepeatingPaymentAdd;
import de.deadlocker8.budgetmasterserver.server.payment.repeating.RepeatingPaymentDelete;
import de.deadlocker8.budgetmasterserver.server.payment.repeating.RepeatingPaymentGet;
import de.deadlocker8.budgetmasterserver.server.payment.repeating.RepeatingPaymentGetAll;
import de.deadlocker8.budgetmasterserver.server.payment.search.PaymentMaxAmount;
import de.deadlocker8.budgetmasterserver.server.payment.search.PaymentSearch;
import de.deadlocker8.budgetmasterserver.server.rest.RestGet;
import de.deadlocker8.budgetmasterserver.server.shutdown.Shutdown;
import de.deadlocker8.budgetmasterserver.server.tag.match.TagMatchAddForPayment;
import de.deadlocker8.budgetmasterserver.server.tag.match.TagMatchAddForRepeatingPayment;
import de.deadlocker8.budgetmasterserver.server.tag.match.TagMatchDeleteForPayment;
import de.deadlocker8.budgetmasterserver.server.tag.match.TagMatchDeleteForRepeatingPayment;
import de.deadlocker8.budgetmasterserver.server.tag.match.TagMatchExistingForPayment;
import de.deadlocker8.budgetmasterserver.server.tag.match.TagMatchExistingForRepeatingPayment;
import de.deadlocker8.budgetmasterserver.server.tag.match.TagMatchGetAllForPayment;
import de.deadlocker8.budgetmasterserver.server.tag.match.TagMatchGetAllForRepeatingPayment;
import de.deadlocker8.budgetmasterserver.server.tag.tag.TagAdd;
import de.deadlocker8.budgetmasterserver.server.tag.tag.TagDelete;
import de.deadlocker8.budgetmasterserver.server.tag.tag.TagGet;
import de.deadlocker8.budgetmasterserver.server.tag.tag.TagGetAll;
import de.deadlocker8.budgetmasterserver.server.tag.tag.TagGetByName;
import de.deadlocker8.budgetmasterserver.server.updater.RepeatingPaymentUpdater;
import java.io.File;
import java.sql.Connection;
import logger.Logger;
import org.joda.time.DateTime;
import spark.Spark;
import spark.route.RouteOverview;
import tools.HashUtils;

public class SparkServer {
    private Gson gson;
    private boolean shutdownInProgress = false;

    public SparkServer(Settings settings, VersionInformation versionInfo) {
        Logger.info("Initializing SparkServer...");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        Spark.port(settings.getServerPort());
        try {
            String filePath = settings.getKeystorePath();
            if (filePath.equals("")) {
                throw new Exception("empty string is no valid keystorePath");
            }
            if (settings.getKeystorePath().equals("default")) {
                Logger.info("Connections are secured with default keystore");
                Logger.warning("The Server is running with the default keystore. This is only recommended if the server is running in a local area network and is not exposed to the internet. Please check if this is intended.");
                Spark.secure(SparkServer.class.getClassLoader().getResource("de/deadlocker8/budgetmasterserver/certificate/default_keystore.jks").toString(), settings.getKeystorePassword(), null, null);
            } else {
                Logger.info("Connections are secured with custom keystore");
                Spark.secure(new File(filePath).getAbsolutePath(), settings.getKeystorePassword(), null, null);
            }
        }
        catch (Exception e) {
            Logger.error(e);
            Logger.info("CANCELED server initialization");
            return;
        }
        RouteOverview.enableRouteOverview();
        Logger.info("Trying to connect to database (jdbc:" + settings.getDatabaseType() + "://" + settings.getDatabaseUrl() + ", databaseName: " + settings.getDatabaseName() + ")");
        try {
            Connection connection = Utils.getDatabaseConnection(settings);
            DatabaseCreator creator = Utils.getDatabaseCreator(connection, settings);
            creator.createTables();
            Logger.info("Successfully initialized database (jdbc:" + settings.getDatabaseType() + "://" + settings.getDatabaseUrl() + ", databaseName: " + settings.getDatabaseName() + ")");
            connection.close();
        }
        catch (Exception e) {
            Logger.error(e);
            throw new IllegalStateException("Cannot connect the database!", e);
        }
        Spark.before((request, response) -> {
            String clientSecret = request.queryMap("secret").value();
            if (clientSecret == null || !clientSecret.equals(HashUtils.hash(settings.getServerSecret(), "ny9/Y+G|WrJ,82|oIYQQ X %i-sq#4,uA-qKPtwFPnw+s(k2`rV)^-a1|t{D3Z>S"))) {
                Logger.debug("Unauthorized request from " + request.ip());
                Spark.halt(401, "Unauthorized");
            }
            DatabaseHandler handler = Utils.getDatabaseHandler(settings);
            RepeatingPaymentUpdater paymentUpdater = new RepeatingPaymentUpdater(handler);
            paymentUpdater.updateRepeatingPayments(DateTime.now());
            handler.closeConnection();
        });
        try {
            Spark.get("/category", new CategoryGetAll(Utils.getDatabaseHandler(settings), this.gson));
            Spark.get("/category/single", new CategoryGet(Utils.getDatabaseHandler(settings), this.gson));
            Spark.post("/category", new CategoryAdd(Utils.getDatabaseHandler(settings)));
            Spark.put("/category", new CategoryUpdate(Utils.getDatabaseHandler(settings)));
            Spark.delete("/category", new CategoryDelete(Utils.getDatabaseHandler(settings)));
            Spark.get("/payment/search", new PaymentSearch(Utils.getDatabaseHandler(settings), Utils.getDatabaseTagHandler(settings)));
            Spark.get("/payment/search/maxAmount", new PaymentMaxAmount(Utils.getDatabaseHandler(settings), this.gson));
            Spark.get("/payment", new PaymentGet(Utils.getDatabaseHandler(settings), this.gson));
            Spark.post("/payment", new PaymentAdd(Utils.getDatabaseHandler(settings), this.gson));
            Spark.put("/payment", new PaymentUpdate(Utils.getDatabaseHandler(settings)));
            Spark.delete("/payment", new PaymentDelete(Utils.getDatabaseHandler(settings), Utils.getDatabaseTagHandler(settings)));
            Spark.get("/repeatingpayment/single", new RepeatingPaymentGet(Utils.getDatabaseHandler(settings), this.gson));
            Spark.get("/repeatingpayment", new RepeatingPaymentGetAll(Utils.getDatabaseHandler(settings), this.gson));
            Spark.post("/repeatingpayment", new RepeatingPaymentAdd(Utils.getDatabaseHandler(settings), this.gson));
            Spark.delete("/repeatingpayment", new RepeatingPaymentDelete(Utils.getDatabaseHandler(settings), Utils.getDatabaseTagHandler(settings)));
            Spark.get("/categorybudget", new CategoryBudgetGet(Utils.getDatabaseHandler(settings), this.gson));
            Spark.get("/rest", new RestGet(Utils.getDatabaseHandler(settings), this.gson));
            Spark.get("/charts/categoryInOutSum", new CategoryInOutSumForMonth(Utils.getDatabaseHandler(settings), this.gson));
            Spark.get("/charts/monthInOutSum", new MonthInOutSum(Utils.getDatabaseHandler(settings), this.gson));
            Spark.get("/tag/single", new TagGet(Utils.getDatabaseTagHandler(settings), this.gson));
            Spark.get("/tag/single/byName", new TagGetByName(Utils.getDatabaseTagHandler(settings), this.gson));
            Spark.get("/tag", new TagGetAll(Utils.getDatabaseTagHandler(settings), this.gson));
            Spark.post("/tag", new TagAdd(Utils.getDatabaseTagHandler(settings)));
            Spark.delete("/tag", new TagDelete(Utils.getDatabaseTagHandler(settings)));
            Spark.get("/tag/match/all/normal", new TagMatchGetAllForPayment(Utils.getDatabaseTagHandler(settings), this.gson));
            Spark.get("/tag/match/all/repeating", new TagMatchGetAllForRepeatingPayment(Utils.getDatabaseTagHandler(settings), this.gson));
            Spark.get("/tag/match/normal", new TagMatchExistingForPayment(Utils.getDatabaseTagHandler(settings), this.gson));
            Spark.get("/tag/match/repeating", new TagMatchExistingForRepeatingPayment(Utils.getDatabaseTagHandler(settings), this.gson));
            Spark.post("/tag/match/normal", new TagMatchAddForPayment(Utils.getDatabaseTagHandler(settings)));
            Spark.post("/tag/match/repeating", new TagMatchAddForRepeatingPayment(Utils.getDatabaseTagHandler(settings)));
            Spark.delete("/tag/match/normal", new TagMatchDeleteForPayment(Utils.getDatabaseTagHandler(settings)));
            Spark.delete("/tag/match/repeating", new TagMatchDeleteForRepeatingPayment(Utils.getDatabaseTagHandler(settings)));
            Spark.get("/database", new DatabaseExport(settings, this.gson));
            Spark.post("/database", new DatabaseImport(Utils.getDatabaseHandler(settings), Utils.getDatabaseTagHandler(settings), this.gson));
            Spark.delete("/database", new DatabaseDelete(Utils.getDatabaseHandler(settings), settings));
            Spark.get("/info", new InformationGet(this.gson, versionInfo, settings));
            Spark.get("/version", new VersionGet(this.gson, versionInfo));
            Spark.delete("/log", new LogDelete());
            Spark.get("/shutdown", new Shutdown(this.shutdownInProgress));
        }
        catch (ClassNotFoundException e) {
            Logger.error(e);
        }
        Spark.after((request, response) -> {
            DatabaseHandler handler = Utils.getDatabaseHandler(settings);
            RepeatingPaymentUpdater paymentUpdater = new RepeatingPaymentUpdater(handler);
            paymentUpdater.updateRepeatingPayments(DateTime.now());
            handler.closeConnection();
        });
        Spark.exception(Exception.class, (exception, request, response) -> Logger.error(exception));
    }
}

