/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.category;

import com.google.gson.Gson;
import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import spark.Request;
import spark.Response;
import spark.Spark;

public class CategoryGet
implements AdvancedRoute {
    private DatabaseHandler handler;
    private Gson gson;

    public CategoryGet(DatabaseHandler handler, Gson gson) {
        this.handler = handler;
        this.gson = gson;
    }

    @Override
    public void before() {
        this.handler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        if (!req.queryParams().contains("id")) {
            Spark.halt(400, "Bad Request");
        }
        int id = -1;
        try {
            id = Integer.parseInt(req.queryMap("id").value());
            if (id < 0) {
                Spark.halt(400, "Bad Request");
            }
            try {
                Category categeory = this.handler.getCategory(id);
                return this.gson.toJson(categeory);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                Spark.halt(500, "Internal Server Error");
            }
        }
        catch (Exception e) {
            Spark.halt(400, "Bad Request");
        }
        return null;
    }

    @Override
    public void after() {
        this.handler.closeConnection();
    }
}

