/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.database;

import com.google.gson.Gson;
import de.deadlocker8.budgetmaster.logic.database.Database;
import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.DatabaseImporter;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import de.deadlocker8.budgetmasterserver.logic.database.taghandler.DatabaseTagHandler;
import logger.Logger;
import spark.Request;
import spark.Response;
import spark.Spark;

public class DatabaseImport
implements AdvancedRoute {
    private DatabaseHandler handler;
    private DatabaseTagHandler tagHandler;
    private Gson gson;

    public DatabaseImport(DatabaseHandler handler, DatabaseTagHandler tagHandler, Gson gson) {
        this.handler = handler;
        this.tagHandler = tagHandler;
        this.gson = gson;
    }

    @Override
    public void before() {
        this.handler.connect();
        this.tagHandler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        String databaseJSON = req.body();
        try {
            Database database = this.gson.fromJson(databaseJSON, Database.class);
            DatabaseImporter importer = new DatabaseImporter(this.handler, this.tagHandler);
            importer.importDatabase(database);
            return "";
        }
        catch (Exception e) {
            Logger.error(e);
            Spark.halt(500, "Internal Server Error");
            return "";
        }
    }

    @Override
    public void after() {
        this.handler.closeConnection();
        this.tagHandler.closeConnection();
    }
}

