/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.payment.search;

import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmaster.logic.payment.NormalPayment;
import de.deadlocker8.budgetmaster.logic.payment.Payment;
import de.deadlocker8.budgetmaster.logic.payment.PaymentJSONSerializer;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPayment;
import de.deadlocker8.budgetmaster.logic.tag.Tag;
import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import de.deadlocker8.budgetmasterserver.logic.database.taghandler.DatabaseTagHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import spark.Request;
import spark.Response;
import spark.Spark;

public class PaymentSearch
implements AdvancedRoute {
    private DatabaseHandler handler;
    private DatabaseTagHandler tagHandler;

    public PaymentSearch(DatabaseHandler handler, DatabaseTagHandler tagHandler) {
        this.handler = handler;
        this.tagHandler = tagHandler;
    }

    private boolean meetsCriteria(Request req, Payment payment) {
        boolean otherChecksThanAmount = false;
        if (req.queryMap("query").value().toLowerCase().equals("")) {
            return this.checkAmount(req, payment);
        }
        if (!(req.queryParams().contains("name") || req.queryParams().contains("description") || req.queryParams().contains("categoryName") || req.queryParams().contains("tags") || req.queryParams().contains("minAmount") || req.queryParams().contains("maxAmount"))) {
            return false;
        }
        if (req.queryParams().contains("name")) {
            otherChecksThanAmount = true;
            if (payment.getName().toLowerCase().contains(req.queryMap("query").value().toLowerCase())) {
                return this.checkAmount(req, payment);
            }
        }
        if (req.queryParams().contains("description")) {
            otherChecksThanAmount = true;
            if (payment.getDescription().toLowerCase().contains(req.queryMap("query").value().toLowerCase())) {
                return this.checkAmount(req, payment);
            }
        }
        if (req.queryParams().contains("categoryName")) {
            otherChecksThanAmount = true;
            int id = payment.getCategoryID();
            if (id == -1) {
                return false;
            }
            Category category = this.handler.getCategory(payment.getCategoryID());
            if (category.getName().toLowerCase().contains(req.queryMap("query").value().toLowerCase())) {
                return this.checkAmount(req, payment);
            }
        }
        if (req.queryParams().contains("tags")) {
            otherChecksThanAmount = true;
            ArrayList<Object> tagIDs = new ArrayList();
            tagIDs = payment instanceof NormalPayment ? this.tagHandler.getAllTagsForPayment(payment.getID()) : this.tagHandler.getAllTagsForRepeatingPayment(payment.getID());
            if (tagIDs.size() > 0) {
                for (Integer n : tagIDs) {
                    Tag currentTag = this.tagHandler.getTagByID(n);
                    if (currentTag == null || !currentTag.getName().toLowerCase().contains(req.queryMap("query").value().toLowerCase())) continue;
                    return this.checkAmount(req, payment);
                }
            }
        }
        if (otherChecksThanAmount) {
            return false;
        }
        return this.checkAmount(req, payment);
    }

    private boolean checkAmount(Request req, Payment payment) {
        if (req.queryParams().contains("minAmount") && req.queryParams().contains("maxAmount")) {
            try {
                int minAmount = Integer.parseInt(req.queryMap("minAmount").value());
                int maxAmount = Integer.parseInt(req.queryMap("maxAmount").value());
                int amount = Math.abs(payment.getAmount());
                return amount >= minAmount && amount <= maxAmount;
            }
            catch (NumberFormatException e) {
                Spark.halt(400, "Bad Request");
            }
        }
        return true;
    }

    @Override
    public void before() {
        this.handler.connect();
        this.tagHandler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        try {
            ArrayList<Payment> payments = new ArrayList<Payment>();
            ArrayList<NormalPayment> normalPayments = this.handler.getAllNormalPayments();
            ArrayList<RepeatingPayment> repeatingPayments = this.handler.getAllRepeatingPayments();
            for (Payment payment : normalPayments) {
                if (!this.meetsCriteria(req, payment)) continue;
                payments.add(payment);
            }
            for (Payment payment : repeatingPayments) {
                if (!this.meetsCriteria(req, payment)) continue;
                payments.add(payment);
            }
            Collections.sort(payments, new Comparator<Payment>(){

                @Override
                public int compare(Payment o1, Payment o2) {
                    return o1.getDate().compareTo(o2.getDate());
                }
            });
            return PaymentJSONSerializer.serializePaymentList(payments);
        }
        catch (IllegalStateException ex) {
            Spark.halt(500, "Internal Server Error");
            return null;
        }
    }

    @Override
    public void after() {
        this.handler.closeConnection();
        this.tagHandler.closeConnection();
    }
}

