/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.tag.match;

import com.google.gson.Gson;
import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.taghandler.DatabaseTagHandler;
import spark.Request;
import spark.Response;
import spark.Spark;

public class TagMatchExistingForPayment
implements AdvancedRoute {
    private DatabaseTagHandler tagHandler;
    private Gson gson;

    public TagMatchExistingForPayment(DatabaseTagHandler tagHandler, Gson gson) {
        this.tagHandler = tagHandler;
        this.gson = gson;
    }

    @Override
    public void before() {
        this.tagHandler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        if (!req.queryParams().contains("tagID") || !req.queryParams().contains("paymentID")) {
            Spark.halt(400, "Bad Request");
        }
        try {
            int tagID = Integer.parseInt(req.queryMap("tagID").value());
            int paymentID = Integer.parseInt(req.queryMap("paymentID").value());
            if (tagID < 0 || paymentID < 0) {
                Spark.halt(400, "Bad Request");
            }
            return this.gson.toJson(this.tagHandler.isMatchExistingForPaymentID(tagID, paymentID));
        }
        catch (IllegalStateException ex) {
            Spark.halt(500, "Internal Server Error");
        }
        catch (Exception e) {
            Spark.halt(400, "Bad Request");
        }
        return null;
    }

    @Override
    public void after() {
        this.tagHandler.closeConnection();
    }
}

