/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.tag.tag;

import com.google.gson.Gson;
import de.deadlocker8.budgetmaster.logic.tag.Tag;
import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.taghandler.DatabaseTagHandler;
import spark.Request;
import spark.Response;
import spark.Spark;

public class TagGet
implements AdvancedRoute {
    private DatabaseTagHandler tagHandler;
    private Gson gson;

    public TagGet(DatabaseTagHandler tagHandler, Gson gson) {
        this.tagHandler = tagHandler;
        this.gson = gson;
    }

    @Override
    public void before() {
        this.tagHandler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        if (!req.queryParams().contains("id")) {
            Spark.halt(400, "Bad Request");
        }
        int id = -1;
        try {
            id = Integer.parseInt(req.queryMap("id").value());
            if (id < 0) {
                Spark.halt(400, "Bad Request");
            }
            try {
                Tag tag = this.tagHandler.getTagByID(id);
                return this.gson.toJson(tag);
            }
            catch (IllegalStateException e) {
                Spark.halt(500, "Internal Server Error");
            }
        }
        catch (Exception e) {
            Spark.halt(400, "Bad Request");
        }
        return null;
    }

    @Override
    public void after() {
        this.tagHandler.closeConnection();
    }
}

