/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import tools.OS;

public class PathUtils {
    public static void checkFolder(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static String getOSindependentPath() {
        switch (OS.getType()) {
            case Windows: {
                return Paths.get(System.getenv("APPDATA"), new String[0]).toAbsolutePath() + "/";
            }
            case MacOSX: {
                return Paths.get(System.getProperty("user.home"), "Library/Application Support/").toAbsolutePath() + "/.";
            }
            case Linux: {
                return Paths.get(System.getProperty("user.home"), new String[0]).toAbsolutePath() + "/.";
            }
        }
        return null;
    }

    public static Path getCurrentLocation() throws URISyntaxException {
        return Paths.get(PathUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
    }

    public static void selectFileInExplorer(String path) throws IOException {
        path = path.replace("/", "\\");
        Runtime.getRuntime().exec(new String[]{"explorer.exe", "/select,", "\"" + path + "\""});
    }
}

