/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.charts;

import de.deadlocker8.budgetmaster.logic.charts.CategoryInOutSum;
import java.util.ArrayList;
import org.joda.time.DateTime;

public class MonthInOutSum {
    private int month;
    private int year;
    private ArrayList<CategoryInOutSum> sums;

    public MonthInOutSum(int month, int year, ArrayList<CategoryInOutSum> sums) {
        this.month = month;
        this.year = year;
        this.sums = sums;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public ArrayList<CategoryInOutSum> getSums() {
        return this.sums;
    }

    public DateTime getDate() {
        return DateTime.now().withYear(this.year).withMonthOfYear(this.month).withDayOfMonth(1);
    }

    public int getBudgetIN() {
        int budget = 0;
        for (CategoryInOutSum currentCategorySum : this.sums) {
            budget += currentCategorySum.getBudgetIN();
        }
        return budget;
    }

    public int getBudgetOUT() {
        int budget = 0;
        for (CategoryInOutSum currentCategorySum : this.sums) {
            budget += currentCategorySum.getBudgetOUT();
        }
        return budget;
    }

    public String toString() {
        return "MonthInOutSum [month=" + this.month + ", year=" + this.year + ", sums=" + this.sums + "]";
    }
}

