/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.report;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chapter;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.GrayColor;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import de.deadlocker8.budgetmaster.logic.Budget;
import de.deadlocker8.budgetmaster.logic.category.CategoryBudget;
import de.deadlocker8.budgetmaster.logic.report.AmountType;
import de.deadlocker8.budgetmaster.logic.report.ColumnType;
import de.deadlocker8.budgetmaster.logic.report.HeaderFooterPageEvent;
import de.deadlocker8.budgetmaster.logic.report.ReportItem;
import de.deadlocker8.budgetmaster.logic.report.ReportPreferences;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import tools.Localization;

public class ReportGenerator {
    private ArrayList<ReportItem> reportItems;
    private ArrayList<CategoryBudget> categoryBudgets;
    private ReportPreferences reportPreferences;
    private File savePath;
    private String currency;
    private DateTime date;
    private Budget budget;
    private final String FONT = "/de/deadlocker8/budgetmaster/resources/fonts/OpenSans-Regular.ttf";

    public ReportGenerator(ArrayList<ReportItem> reportItems, ArrayList<CategoryBudget> categoryBudgets, ReportPreferences reportPreferences, File savePath, String currency, DateTime date, Budget budget) {
        this.reportItems = reportItems;
        this.categoryBudgets = categoryBudgets;
        this.reportPreferences = reportPreferences;
        this.savePath = savePath;
        this.currency = currency;
        this.date = date;
        this.budget = budget;
    }

    private Chapter generateHeader() {
        Font font = FontFactory.getFont("/de/deadlocker8/budgetmaster/resources/fonts/OpenSans-Regular.ttf", "Identity-H", true, 16.0f, 3, BaseColor.BLACK);
        Chunk chunk = new Chunk(Localization.getString("report.headline", this.date.toString("MMMM yyyy")), font);
        Chapter chapter = new Chapter(new Paragraph(chunk), 1);
        chapter.setNumberDepth(0);
        chapter.add(Chunk.NEWLINE);
        return chapter;
    }

    private PdfPTable generateTable(int tableWidth, AmountType amountType) {
        int numberOfColumns = this.reportPreferences.getColumnOrder().getColumns().size();
        int totalIncome = 0;
        int totalPayment = 0;
        if (numberOfColumns > 0) {
            float[] proportions = new float[numberOfColumns];
            for (int i = 0; i < this.reportPreferences.getColumnOrder().getColumns().size(); ++i) {
                proportions[i] = this.reportPreferences.getColumnOrder().getColumns().get(i).getProportion();
            }
            PdfPTable table = new PdfPTable(proportions);
            table.setWidthPercentage(tableWidth);
            Font font = FontFactory.getFont("/de/deadlocker8/budgetmaster/resources/fonts/OpenSans-Regular.ttf", "Identity-H", true, 8.0f, 0, GrayColor.BLACK);
            for (ColumnType column : this.reportPreferences.getColumnOrder().getColumns()) {
                PdfPCell cell = new PdfPCell(new Phrase(column.getName(), font));
                cell.setBackgroundColor(GrayColor.LIGHT_GRAY);
                cell.setHorizontalAlignment(1);
                cell.setVerticalAlignment(5);
                table.addCell(cell);
            }
            for (ReportItem currentItem : this.reportItems) {
                if (currentItem.getAmount() > 0) {
                    totalIncome += currentItem.getAmount();
                    if (amountType == AmountType.PAYMENT) {
                        continue;
                    }
                } else {
                    totalPayment += currentItem.getAmount();
                    if (amountType == AmountType.INCOME) continue;
                }
                for (ColumnType column : this.reportPreferences.getColumnOrder().getColumns()) {
                    PdfPCell cell = new PdfPCell(new Phrase(this.getProperty(currentItem, column), font));
                    cell.setBackgroundColor(new BaseColor(Color.WHITE));
                    cell.setHorizontalAlignment(1);
                    cell.setVerticalAlignment(5);
                    table.addCell(cell);
                }
            }
            String total = "";
            switch (amountType) {
                case BOTH: {
                    String totalIncomeString = Helpers.getCurrencyString(totalIncome, this.currency);
                    String totalPaymentString = Helpers.getCurrencyString(totalPayment, this.currency);
                    total = Localization.getString("report.sum.total", totalIncomeString, totalPaymentString);
                    break;
                }
                case INCOME: {
                    total = Localization.getString("report.sum", Helpers.getCurrencyString(totalIncome, this.currency));
                    break;
                }
                case PAYMENT: {
                    total = Localization.getString("report.sum", Helpers.getCurrencyString(totalPayment, this.currency));
                    break;
                }
            }
            PdfPCell cellTotal = new PdfPCell(new Phrase(total, font));
            cellTotal.setBackgroundColor(new BaseColor(Color.WHITE));
            cellTotal.setColspan(numberOfColumns);
            cellTotal.setHorizontalAlignment(2);
            cellTotal.setVerticalAlignment(5);
            table.addCell(cellTotal);
            return table;
        }
        return null;
    }

    public void generate() throws FileNotFoundException, DocumentException {
        PdfPTable table;
        Document document = new Document();
        PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(this.savePath));
        writer.setPageEvent(new HeaderFooterPageEvent());
        document.open();
        document.setMargins(50.0f, 45.0f, 50.0f, 70.0f);
        Font headerFont = FontFactory.getFont("/de/deadlocker8/budgetmaster/resources/fonts/OpenSans-Regular.ttf", "Identity-H", true, 14.0f, 1, BaseColor.BLACK);
        Font smallHeaderFont = FontFactory.getFont("/de/deadlocker8/budgetmaster/resources/fonts/OpenSans-Regular.ttf", "Identity-H", true, 12.0f, 1, BaseColor.BLACK);
        document.add(this.generateHeader());
        document.add(Chunk.NEWLINE);
        if (this.reportPreferences.isIncludeBudget()) {
            Font fontGreen = FontFactory.getFont("/de/deadlocker8/budgetmaster/resources/fonts/OpenSans-Regular.ttf", "Identity-H", true, 12.0f, 0, new BaseColor(36, 122, 45));
            Font fontRed = FontFactory.getFont("/de/deadlocker8/budgetmaster/resources/fonts/OpenSans-Regular.ttf", "Identity-H", true, 12.0f, 0, BaseColor.RED);
            Font fontBlack = FontFactory.getFont("/de/deadlocker8/budgetmaster/resources/fonts/OpenSans-Regular.ttf", "Identity-H", true, 12.0f, 1, BaseColor.BLACK);
            document.add(new Paragraph(Localization.getString("report.budget"), headerFont));
            document.add(Chunk.NEWLINE);
            document.add(new Paragraph(Localization.getString("report.incomes") + Helpers.getCurrencyString(this.budget.getIncomeSum(), this.currency), fontGreen));
            document.add(new Paragraph(Localization.getString("report.payments") + Helpers.getCurrencyString(this.budget.getPaymentSum(), this.currency), fontRed));
            document.add(new Paragraph(Localization.getString("report.budget.rest") + Helpers.getCurrencyString(this.budget.getIncomeSum() + this.budget.getPaymentSum(), this.currency), fontBlack));
            document.add(Chunk.NEWLINE);
        }
        document.add(new Paragraph(Localization.getString("report.headline.payments.overview"), headerFont));
        document.add(Chunk.NEWLINE);
        if (this.reportPreferences.isSplitTable()) {
            document.add(new Paragraph(Localization.getString("title.incomes"), smallHeaderFont));
            document.add(Chunk.NEWLINE);
            table = this.generateTable(100, AmountType.INCOME);
            if (table != null) {
                document.add(table);
            }
            document.add(Chunk.NEWLINE);
            document.add(new Paragraph(Localization.getString("title.payments"), smallHeaderFont));
            document.add(Chunk.NEWLINE);
            table = this.generateTable(100, AmountType.PAYMENT);
            if (table != null) {
                document.add(table);
            }
        } else {
            table = this.generateTable(100, AmountType.BOTH);
            if (table != null) {
                document.add(table);
            }
        }
        if (this.reportPreferences.isIncludeCategoryBudgets()) {
            document.add(Chunk.NEWLINE);
            document.add(new Paragraph(Localization.getString("title.category.budgets"), smallHeaderFont));
            document.add(Chunk.NEWLINE);
            table = this.generateCategoryBudgets();
            if (table != null) {
                document.add(table);
            }
        }
        document.close();
    }

    private PdfPTable generateCategoryBudgets() {
        PdfPTable table = new PdfPTable(2);
        table.setWidthPercentage(100.0f);
        Font font = FontFactory.getFont("/de/deadlocker8/budgetmaster/resources/fonts/OpenSans-Regular.ttf", "Identity-H", true, 8.0f, 0, BaseColor.BLACK);
        PdfPCell cellHeaderCategory = new PdfPCell(new Phrase(Localization.getString("title.category"), font));
        cellHeaderCategory.setBackgroundColor(GrayColor.LIGHT_GRAY);
        cellHeaderCategory.setHorizontalAlignment(1);
        table.addCell(cellHeaderCategory);
        PdfPCell cellHeaderAmount = new PdfPCell(new Phrase(Localization.getString("title.amount"), font));
        cellHeaderAmount.setBackgroundColor(GrayColor.LIGHT_GRAY);
        cellHeaderAmount.setHorizontalAlignment(1);
        table.addCell(cellHeaderAmount);
        for (CategoryBudget budget : this.categoryBudgets) {
            PdfPCell cellName = new PdfPCell(new Phrase(budget.getCategory().getName(), font));
            cellName.setBackgroundColor(new BaseColor(Color.WHITE));
            cellName.setHorizontalAlignment(1);
            cellName.setVerticalAlignment(5);
            table.addCell(cellName);
            PdfPCell cellAmount = new PdfPCell(new Phrase(Helpers.getCurrencyString(budget.getBudget() / 100.0, this.currency), font));
            cellAmount.setBackgroundColor(new BaseColor(Color.WHITE));
            cellAmount.setHorizontalAlignment(1);
            cellAmount.setVerticalAlignment(5);
            table.addCell(cellAmount);
        }
        return table;
    }

    private String getProperty(ReportItem reportItem, ColumnType columnType) {
        switch (columnType) {
            case AMOUNT: {
                return Helpers.getCurrencyString(reportItem.getAmount(), this.currency);
            }
            case CATEGORY: {
                return reportItem.getCategory().getName();
            }
            case DATE: {
                return DateTime.parse(reportItem.getDate(), DateTimeFormat.forPattern("YYYY-MM-dd")).toString("dd.MM.YYYY");
            }
            case DESCRIPTION: {
                return reportItem.getDescription();
            }
            case TAGS: {
                return reportItem.getTags();
            }
            case NAME: {
                return reportItem.getName();
            }
            case POSITION: {
                return String.valueOf(reportItem.getPosition());
            }
            case RATING: {
                return reportItem.getAmount() > 0 ? "+" : "-";
            }
            case REPEATING: {
                if (reportItem.getRepeating()) {
                    return Localization.getString("report.repeating.yes");
                }
                return Localization.getString("report.repeating.no");
            }
        }
        return null;
    }
}

