/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.serverconnection;

import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnectionException;
import java.net.UnknownHostException;
import tools.Localization;

public class ExceptionHandler {
    public static String getMessageForException(Exception e) {
        if (e instanceof ServerConnectionException) {
            return ExceptionHandler.handleServerConnectionException(e);
        }
        if (e instanceof UnknownHostException) {
            return Localization.getString("error.unknown.host");
        }
        if (e.getMessage() == null) {
            return Localization.getString("error.unknown.error", e.getClass());
        }
        if (e.getMessage().contains("Connection refused")) {
            return Localization.getString("error.connection.refused");
        }
        if (e.getMessage().contains("HTTPS hostname wrong")) {
            return Localization.getString("error.https.hostname.wrong");
        }
        return e.getMessage();
    }

    private static String handleServerConnectionException(Exception e) {
        switch (e.getMessage()) {
            case "400": {
                return Localization.getString("error.400");
            }
            case "401": {
                return Localization.getString("error.401");
            }
            case "500": {
                return Localization.getString("error.500");
            }
        }
        return e.getMessage();
    }
}

