/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.serverconnection;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.deadlocker8.budgetmaster.logic.Settings;
import de.deadlocker8.budgetmaster.logic.payment.NormalPayment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPayment;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnectionException;
import de.deadlocker8.budgetmaster.logic.tag.Tag;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import tools.Read;

public class ServerTagConnection {
    private Settings settings;
    private Gson gson;

    public ServerTagConnection(Settings settings) throws Exception {
        this.settings = settings;
        this.gson = new Gson();
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier((hostname, sslSession) -> settings.getTrustedHosts().contains(hostname));
    }

    public ArrayList<Tag> getTags() throws Exception {
        URL url = new URL(this.settings.getUrl() + "/tag?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            Type listType = new TypeToken<ArrayList<Tag>>(){}.getType();
            return (ArrayList)this.gson.fromJson(result, listType);
        }
        return new ArrayList<Tag>();
    }

    public Tag getTag(int ID) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/tag/single?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&id=" + ID);
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            return this.gson.fromJson(result, Tag.class);
        }
        return null;
    }

    public Tag getTag(String name) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/tag/single/byName?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&name=" + Helpers.getURLEncodedString(name));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            return this.gson.fromJson(result, Tag.class);
        }
        return null;
    }

    public void addTag(Tag tag) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/tag?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&name=" + Helpers.getURLEncodedString(tag.getName()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("POST");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public void deleteTag(int ID) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/tag?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&id=" + ID);
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("DELETE");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public boolean isMatchExistingForPayment(int tagID, NormalPayment payment) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/tag/match/normal?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&tagID=" + tagID + "&paymentID=" + payment.getID());
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            return this.gson.fromJson(result, Boolean.class);
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public boolean isMatchExistingForRepeatingPayment(int tagID, RepeatingPayment payment) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/tag/match/repeating?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&tagID=" + tagID + "&repeatingPaymentID=" + payment.getID());
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            return this.gson.fromJson(result, Boolean.class);
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public void addTagMatchForPayment(int tagID, NormalPayment payment) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/tag/match/normal?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&tagID=" + tagID + "&paymentID=" + payment.getID());
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("POST");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public void addTagMatchForRepeatingPayment(int tagID, RepeatingPayment payment) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/tag/match/repeating?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&tagID=" + tagID + "&repeatingPaymentID=" + payment.getID());
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("POST");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public void deleteTagMatchForPayment(int tagID, NormalPayment payment) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/tag/match/normal?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&tagID=" + tagID + "&paymentID=" + payment.getID());
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("DELETE");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public void deleteTagMatchForRepeatingPayment(int tagID, RepeatingPayment payment) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/tag/match/repeating?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&tagID=" + tagID + "&repeatingPaymentID=" + payment.getID());
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("DELETE");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public ArrayList<Tag> getAllTagsForPayment(NormalPayment payment) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/tag/match/all/normal?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&paymentID=" + payment.getID());
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            Type listType = new TypeToken<ArrayList<Tag>>(){}.getType();
            return (ArrayList)this.gson.fromJson(result, listType);
        }
        return new ArrayList<Tag>();
    }

    public ArrayList<Tag> getAllTagsForRepeatingPayment(int repeatingPaymentID) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/tag/match/all/repeating?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&repeatingPaymentID=" + repeatingPaymentID);
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            Type listType = new TypeToken<ArrayList<Tag>>(){}.getType();
            return (ArrayList)this.gson.fromJson(result, listType);
        }
        return new ArrayList<Tag>();
    }
}

