/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.colorPick;

import de.deadlocker8.budgetmasterclient.ui.colorPick.ColorPickController;
import de.deadlocker8.budgetmasterclient.ui.controller.NewCategoryController;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.util.ArrayList;
import java.util.function.Consumer;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Modality;
import javafx.stage.Stage;
import logger.Logger;
import tools.ConvertTo;
import tools.Localization;

public class ColorView
extends GridPane {
    private Node lastSelectedNode;
    private Color colorPickerColor;
    private Button buttonColorPicker;
    private FontIcon icon;

    public ColorView(Color startColor, ArrayList<Color> colors, NewCategoryController controller, Consumer<Color> finish) {
        colors.add(Color.TRANSPARENT);
        double size = Math.sqrt(colors.size());
        int iSize = (int)size;
        if (size != (double)iSize) {
            ++iSize;
        }
        this.setVgap(5.0);
        this.setHgap(5.0);
        this.setPadding(new Insets(5.0));
        this.colorPickerColor = Color.WHITE;
        int index = 0;
        for (int y = 0; y < iSize; ++y) {
            for (int x = 0; x < iSize; ++x) {
                Color color;
                if (index >= colors.size()) continue;
                if ((color = colors.get(index++)) == Color.TRANSPARENT) {
                    this.buttonColorPicker = new Button();
                    this.buttonColorPicker.setPrefHeight(40.0);
                    this.buttonColorPicker.setPrefWidth(40.0);
                    if (!colors.contains(startColor)) {
                        this.colorPickerColor = startColor;
                        this.updateColorPickerCSS((Node)this.buttonColorPicker, true, startColor);
                    }
                    this.icon = new FontIcon(FontIconType.PLUS);
                    this.icon.setSize(20);
                    this.icon.setStyle("-fx-text-fill: " + ConvertTo.toRGBHex(ConvertTo.getAppropriateTextColor(this.colorPickerColor)));
                    this.buttonColorPicker.setGraphic((Node)this.icon);
                    this.buttonColorPicker.setOnAction(event -> {
                        try {
                            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getClassLoader().getResource("de/deadlocker8/budgetmaster/ui/colorPick/ColorPickGUI.fxml"));
                            loader.setResources(Localization.getBundle());
                            Parent root = (Parent)loader.load();
                            Scene scene = new Scene(root, 500.0, 225.0);
                            Stage stage = new Stage();
                            ((ColorPickController)loader.getController()).init(stage, finishColor -> {
                                this.colorPickerColor = finishColor;
                                this.updateColorPickerCSS((Node)this.buttonColorPicker, true, (Color)finishColor);
                                if (this.lastSelectedNode instanceof Rectangle) {
                                    ((Rectangle)this.lastSelectedNode).getStrokeDashArray().clear();
                                }
                                this.lastSelectedNode = this.buttonColorPicker;
                                this.icon.setStyle("-fx-text-fill: " + ConvertTo.toRGBHex(ConvertTo.getAppropriateTextColor(finishColor)));
                                finish.accept((Color)finishColor);
                            });
                            stage.setResizable(false);
                            stage.initModality(Modality.APPLICATION_MODAL);
                            stage.setScene(scene);
                            stage.getIcons().add((Object)new Image("/de/deadlocker8/budgetmaster/icon.png"));
                            stage.show();
                        }
                        catch (Exception e) {
                            Logger.error(e);
                        }
                    });
                    this.add((Node)this.buttonColorPicker, x, y);
                    continue;
                }
                Rectangle rectangle = this.createRectangle(startColor, color);
                rectangle.setOnMouseReleased(event -> {
                    if (this.lastSelectedNode instanceof Rectangle) {
                        ((Rectangle)this.lastSelectedNode).getStrokeDashArray().clear();
                    } else {
                        this.updateColorPickerCSS((Node)this.buttonColorPicker, false, Color.WHITE);
                        this.icon.setStyle("-fx-text-fill: " + ConvertTo.toRGBHex(ConvertTo.getAppropriateTextColor(Color.WHITE)));
                    }
                    rectangle.getStrokeDashArray().add((Object)3.0);
                    this.lastSelectedNode = rectangle;
                    finish.accept(color);
                });
                this.add((Node)rectangle, x, y);
            }
        }
        this.updateColorPickerCSS((Node)this.buttonColorPicker, true, this.colorPickerColor);
    }

    private Rectangle createRectangle(Color startColor, Color color) {
        Rectangle rectangle = new Rectangle(40.0, 40.0);
        rectangle.setFill((Paint)color);
        rectangle.getStyleClass().add((Object)"color-view-item");
        if (ConvertTo.toRGBHex(color).equals(ConvertTo.toRGBHex(startColor))) {
            this.lastSelectedNode = rectangle;
            rectangle.getStrokeDashArray().add((Object)3.0);
        }
        return rectangle;
    }

    private void updateColorPickerCSS(Node button, boolean dashed, Color backgroundColor) {
        String css = "-fx-background-radius: 4; -fx-border-width: 1.8; -fx-border-color: black; -fx-border-radius: 4; -fx-background-color: " + ConvertTo.toRGBHex(backgroundColor) + ";";
        if (dashed) {
            css = css + " -fx-border-style: dashed;";
        }
        button.setStyle(css);
    }
}

