/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller.settings;

import de.deadlocker8.budgetmaster.logic.ServerType;
import de.deadlocker8.budgetmaster.logic.Settings;
import de.deadlocker8.budgetmaster.logic.localserver.LocalServerException;
import de.deadlocker8.budgetmaster.logic.localserver.LocalServerHandler;
import de.deadlocker8.budgetmaster.logic.localserver.LocalServerStatus;
import de.deadlocker8.budgetmaster.logic.updater.Updater;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.FileHelper;
import de.deadlocker8.budgetmaster.logic.utils.LanguageType;
import de.deadlocker8.budgetmasterclient.ui.RestartHandler;
import de.deadlocker8.budgetmasterclient.ui.cells.LanguageCell;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import de.deadlocker8.budgetmasterclient.ui.controller.settings.SettingsController;
import de.deadlocker8.budgetmasterclient.utils.LoadingModal;
import java.io.IOException;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.stage.Window;
import logger.Logger;
import tools.AlertGenerator;
import tools.ConvertTo;
import tools.HashUtils;
import tools.Localization;
import tools.Worker;

public class LocalServerSettingsController
extends SettingsController {
    @FXML
    private AnchorPane anchorPaneMain;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private HBox hboxSettings;
    @FXML
    private ToggleButton toggleButtonOnline;
    @FXML
    private ToggleButton toggleButtonLocal;
    @FXML
    private Label labelStatus;
    @FXML
    private Label labelLocalServerStatus;
    @FXML
    private Button buttonLocalServerAction;
    @FXML
    private Label labelClientSecret;
    @FXML
    private TextField textFieldClientSecret;
    @FXML
    private TextField textFieldCurrency;
    @FXML
    private Label labelCurrency;
    @FXML
    private Button buttonSave;
    @FXML
    private Button buttonExportDB;
    @FXML
    private Button buttonImportDB;
    @FXML
    private Button buttonDeleteDB;
    @FXML
    private RadioButton radioButtonRestActivated;
    @FXML
    private RadioButton radioButtonRestDeactivated;
    @FXML
    private ComboBox<LanguageType> comboBoxLanguage;
    @FXML
    private CheckBox checkboxEnableAutoUpdate;
    @FXML
    private Button buttonSearchUpdates;
    @FXML
    private Label labelCurrentVersion;
    @FXML
    private Label labelLatestVersion;
    private LanguageType previousLanguage;
    private final int MILLIS_UNTIL_NEXT_RETRY = 2000;
    private final int MAX_NUMBER_OF_RETRIES = 5;

    @Override
    public void init(Controller controller) {
        this.controller = controller;
        ToggleGroup toggleGroupServerType = new ToggleGroup();
        this.toggleButtonOnline.setToggleGroup(toggleGroupServerType);
        this.toggleButtonLocal.setToggleGroup(toggleGroupServerType);
        this.toggleButtonOnline.setOnAction(event -> {
            controller.getSettings().setServerType(ServerType.ONLINE);
            controller.loadSettingsTab();
        });
        this.textFieldClientSecret.setText("******");
        this.comboBoxLanguage.setCellFactory(view -> new LanguageCell(true));
        this.comboBoxLanguage.getItems().addAll((Object[])LanguageType.values());
        this.comboBoxLanguage.setButtonCell((ListCell)new LanguageCell(false));
        this.comboBoxLanguage.setValue((Object)LanguageType.ENGLISH);
        this.previousLanguage = LanguageType.ENGLISH;
        this.checkboxEnableAutoUpdate.setSelected(true);
        this.applyStyle();
        this.textFieldCurrency.setPromptText(Localization.getString("currency.placeholder"));
        ToggleGroup toggleGroup = new ToggleGroup();
        this.radioButtonRestActivated.setToggleGroup(toggleGroup);
        this.radioButtonRestDeactivated.setToggleGroup(toggleGroup);
        this.hboxSettings.prefWidthProperty().bind((ObservableValue)this.scrollPane.widthProperty().subtract(25));
        this.refreshLabelsUpdate();
        this.prefill();
        this.checkServerStatus();
    }

    @Override
    public void prefill() {
        this.textFieldCurrency.setText(this.controller.getSettings().getCurrency());
        if (this.controller.getSettings().isRestActivated()) {
            this.radioButtonRestActivated.setSelected(true);
        } else {
            this.radioButtonRestDeactivated.setSelected(true);
        }
        if (this.controller.getSettings().getLanguage() != null) {
            LanguageType language = this.controller.getSettings().getLanguage();
            this.comboBoxLanguage.setValue((Object)language);
            this.previousLanguage = language;
        }
        this.checkboxEnableAutoUpdate.setSelected(this.controller.getSettings().isAutoUpdateCheckEnabled());
    }

    private void checkServerStatus() {
        LocalServerHandler serverHandler = new LocalServerHandler();
        switch (serverHandler.getServerStatus()) {
            case ACTIVE: {
                this.labelLocalServerStatus.setText(Localization.getString("local.server.status.ok"));
                this.buttonLocalServerAction.setVisible(false);
                this.refreshLabelsUpdate();
                this.save();
                break;
            }
            case INACTIVE: {
                Platform.runLater(() -> LoadingModal.showModal(this.controller, Localization.getString("title.modal"), Localization.getString("load.local.server"), this.controller.getStage(), this.controller.getIcon()));
                this.labelLocalServerStatus.setText(Localization.getString("local.server.status.not.started"));
                this.buttonLocalServerAction.setVisible(false);
                Worker.runLater(() -> {
                    try {
                        Logger.debug("Starting local Server...");
                        serverHandler.createServerSettingsIfNotExists();
                        serverHandler.startServer();
                        Logger.debug("Trying to connect to local server...");
                        Platform.runLater(() -> LoadingModal.setMessage(Localization.getString("load.local.server.connect")));
                        int retryCount = 1;
                        while (retryCount <= 5) {
                            int retries = retryCount;
                            boolean isActive = serverHandler.getServerStatus().equals((Object)LocalServerStatus.ACTIVE);
                            if (isActive) {
                                Logger.debug("Connected to local server");
                                break;
                            }
                            if (retryCount == 5) {
                                Logger.debug("Couldn't connect to local server. Giving up after " + retryCount + " retries.");
                                throw new LocalServerException("");
                            }
                            Logger.debug("Couldn't connect to local server. Retry " + retryCount + "/" + 5 + ". Next Retry in " + 2 + " Seconds...");
                            Platform.runLater(() -> LoadingModal.setMessage(Localization.getString("load.local.server.retry", retries, 5)));
                            ++retryCount;
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    catch (IOException e) {
                        Logger.debug("Error while starting local server");
                        Logger.error(e);
                        Platform.runLater(() -> {
                            LoadingModal.closeModal();
                            AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.local.server.start", e.getMessage()), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
                            this.controller.forceSettingsTab();
                        });
                        return;
                    }
                    catch (LocalServerException ex) {
                        Logger.debug("Error while starting local server");
                        Platform.runLater(() -> {
                            LoadingModal.closeModal();
                            AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.local.server.start", ""), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
                            this.controller.refresh(this.controller.getFilterSettings());
                            this.buttonLocalServerAction.setText(Localization.getString("local.server.action.not.started"));
                            this.buttonLocalServerAction.setVisible(true);
                            this.buttonLocalServerAction.setDisable(false);
                            this.buttonLocalServerAction.setOnAction(event -> {
                                this.buttonLocalServerAction.setDisable(true);
                                this.checkServerStatus();
                            });
                        });
                        return;
                    }
                    Platform.runLater(() -> {
                        this.checkServerStatus();
                        LoadingModal.closeModal();
                    });
                });
                break;
            }
            case MISSING: {
                this.controller.forceSettingsTab();
                this.labelLocalServerStatus.setText(Localization.getString("local.server.status.not.present"));
                this.buttonLocalServerAction.setText(Localization.getString("local.server.action.not.present"));
                this.buttonLocalServerAction.setVisible(true);
                this.buttonLocalServerAction.setDisable(false);
                this.buttonLocalServerAction.setOnAction(event -> {
                    this.buttonLocalServerAction.setDisable(true);
                    LoadingModal.showModal(this.controller, Localization.getString("title.modal"), Localization.getString("load.download.local.server"), this.controller.getStage(), this.controller.getIcon());
                    Worker.runLater(() -> {
                        try {
                            serverHandler.downloadServer(Localization.getString("version.name"));
                            serverHandler.createServerSettingsIfNotExists();
                            Platform.runLater(() -> {
                                this.checkServerStatus();
                                LoadingModal.closeModal();
                            });
                        }
                        catch (Exception e) {
                            Logger.error(e);
                            Platform.runLater(() -> {
                                LoadingModal.closeModal();
                                AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.local.server.download", e.getMessage()), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
                                this.buttonLocalServerAction.setDisable(false);
                            });
                        }
                    });
                });
                break;
            }
        }
    }

    @Override
    void refreshLabelsUpdate() {
        Updater updater = this.controller.getUpdater();
        this.labelCurrentVersion.setText(Localization.getString("version.name"));
        this.labelLatestVersion.setText(updater.getLatestVersion().getVersionName());
    }

    @Override
    public void save() {
        String clientSecret = this.textFieldClientSecret.getText();
        String currency = this.textFieldCurrency.getText();
        if (clientSecret == null || clientSecret.trim().equals("")) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.empty.secret.client"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
            return;
        }
        clientSecret = clientSecret.trim();
        if (currency == null || currency.trim().equals("")) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.empty.currency"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
            return;
        }
        currency = currency.trim();
        if (this.controller.getSettings().isComplete()) {
            if (!clientSecret.equals("******")) {
                this.controller.getSettings().setClientSecret(HashUtils.hash(clientSecret, "ny9/Y+G|WrJ,82|oIYQQ X %i-sq#4,uA-qKPtwFPnw+s(k2`rV)^-a1|t{D3Z>S"));
            }
            this.controller.getSettings().setCurrency(currency);
            this.controller.getSettings().setRestActivated(this.radioButtonRestActivated.isSelected());
            this.controller.getSettings().setLanguage((LanguageType)((Object)this.comboBoxLanguage.getValue()));
            this.controller.getSettings().setAutoUpdateCheckEnabled(this.checkboxEnableAutoUpdate.isSelected());
        } else {
            Settings settings = new Settings();
            if (!clientSecret.equals("******")) {
                settings.setClientSecret(HashUtils.hash(clientSecret, "ny9/Y+G|WrJ,82|oIYQQ X %i-sq#4,uA-qKPtwFPnw+s(k2`rV)^-a1|t{D3Z>S"));
            } else {
                settings.setClientSecret(this.controller.getSettings().getClientSecret());
            }
            settings.setCurrency(currency);
            settings.setRestActivated(this.radioButtonRestActivated.isSelected());
            settings.setLanguage((LanguageType)((Object)this.comboBoxLanguage.getValue()));
            settings.setAutoUpdateCheckEnabled(this.checkboxEnableAutoUpdate.isSelected());
            this.controller.setSettings(settings);
        }
        this.controller.getSettings().setServerType(ServerType.LOCAL);
        this.controller.getSettings().setSecret(HashUtils.hash("BudgetMaster", "ny9/Y+G|WrJ,82|oIYQQ X %i-sq#4,uA-qKPtwFPnw+s(k2`rV)^-a1|t{D3Z>S"));
        this.controller.getSettings().setUrl("https://localhost:9000");
        ArrayList<String> trustedHosts = new ArrayList<String>();
        trustedHosts.add("localhost");
        this.controller.getSettings().setTrustedHosts(trustedHosts);
        try {
            FileHelper.saveSettings(this.controller.getSettings());
        }
        catch (IOException e) {
            Logger.error(e);
            AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.settings.save"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
        }
        this.textFieldClientSecret.setText("******");
        RestartHandler restartHandler = new RestartHandler(this.controller);
        restartHandler.handleRestart(this.previousLanguage);
        this.refreshLabelsUpdate();
    }

    public void handleIncompatibleServer() {
        this.labelLocalServerStatus.setText(Localization.getString("local.server.status.incompatible"));
        this.buttonLocalServerAction.setText(Localization.getString("local.server.action.incompatible"));
        this.buttonLocalServerAction.setVisible(true);
        this.buttonLocalServerAction.setDisable(false);
        this.buttonLocalServerAction.setOnAction(event -> {
            this.buttonLocalServerAction.setDisable(true);
            LoadingModal.showModal(this.controller, Localization.getString("title.modal"), Localization.getString("load.download.local.server"), this.controller.getStage(), this.controller.getIcon());
            Worker.runLater(() -> {
                try {
                    LocalServerHandler serverHandler = new LocalServerHandler();
                    serverHandler.shutdownServer();
                    Thread.sleep(3000L);
                    serverHandler.downloadServer(Localization.getString("version.name"));
                    serverHandler.createServerSettingsIfNotExists();
                    Platform.runLater(() -> {
                        this.checkServerStatus();
                        LoadingModal.closeModal();
                    });
                }
                catch (Exception e) {
                    Logger.error(e);
                    Platform.runLater(() -> {
                        LoadingModal.closeModal();
                        AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.local.server.download", e.getMessage()), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
                        this.buttonLocalServerAction.setDisable(false);
                    });
                }
            });
        });
    }

    @Override
    public void applyStyle() {
        this.anchorPaneMain.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND));
        this.scrollPane.setStyle("-fx-background-color: transparent");
        this.labelClientSecret.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.labelStatus.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.labelCurrency.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.toggleButtonOnline.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14; -fx-background-radius: 3 0 0 3");
        this.toggleButtonLocal.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_DARK_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14; -fx-background-radius: 0 3 3 0; -fx-effect: innershadow(gaussian, rgba(0,0,0,0.7), 10,0,0,0);");
        this.buttonSave.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 16;");
        this.buttonLocalServerAction.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14;");
        this.buttonExportDB.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14;");
        this.buttonImportDB.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14;");
        this.buttonDeleteDB.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_RED) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14;");
        this.buttonSearchUpdates.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14;");
    }
}

