/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.utils;

import de.deadlocker8.budgetmaster.logic.serverconnection.ExceptionHandler;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnection;
import de.deadlocker8.budgetmaster.logic.utils.FileHelper;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import de.deadlocker8.budgetmasterclient.utils.LoadingModal;
import java.io.File;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import logger.Logger;
import tools.AlertGenerator;
import tools.Localization;
import tools.Worker;

public class DatabaseExporter {
    private Controller controller;

    public DatabaseExporter(Controller controller) {
        this.controller = controller;
    }

    public void exportDatabase() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(Localization.getString("title.database.export"));
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("JSON (*.json)", new String[]{"*.json"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showSaveDialog((Window)this.controller.getStage());
        if (file != null) {
            LoadingModal.showModal(this.controller, Localization.getString("title.modal"), Localization.getString("load.database.export"), this.controller.getStage(), this.controller.getIcon());
            Worker.runLater(() -> {
                try {
                    ServerConnection connection = new ServerConnection(this.controller.getSettings());
                    String databaseJSON = connection.exportDatabase();
                    FileHelper.saveDatabaseJSON(file, databaseJSON);
                    Platform.runLater(() -> {
                        LoadingModal.closeModal();
                        AlertGenerator.showAlert(Alert.AlertType.INFORMATION, Localization.getString("info.title.database.export"), "", Localization.getString("info.text.database.export"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
                    });
                }
                catch (Exception e) {
                    Logger.error(e);
                    Platform.runLater(() -> {
                        LoadingModal.closeModal();
                        this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
                    });
                }
            });
        }
    }
}

