/*
 * Decompiled with CFR 0.152.
 */
package fontAwesome;

import fontAwesome.FontIconType;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class FontIcon
extends Label {
    private static Map<String, Map<Integer, Font>> fonts;
    public static final String STYLE_CLASS = "fonticon";
    private static String FONT_FILE;
    private String fontFile = FONT_FILE;
    private int size = 14;
    private Font font;
    private Color color;

    static {
        FONT_FILE = "fontAwesome/fontawesome-webfont.ttf";
        fonts = new HashMap<String, Map<Integer, Font>>();
    }

    public static void setDefaultFontFile(String file) {
        FONT_FILE = file;
    }

    public FontIcon(FontIconType type, int size, Color color) {
        this(type);
        this.setSize(size);
        this.setColor(color);
    }

    public FontIcon(FontIconType type) {
        this(new FontIconType[]{type});
    }

    public FontIcon(FontIconType ... types) {
        this(FONT_FILE, types);
    }

    public FontIcon(FontIconType type, String fontFile) {
        this(new FontIconType[]{type});
    }

    public FontIcon(String fontFile, FontIconType ... types) {
        this.fontFile = fontFile;
        this.setIcons(types);
        this.loadFont();
        this.getStyleClass().remove((Object)"label");
        this.getStyleClass().add((Object)STYLE_CLASS);
    }

    public void setIcons(FontIconType ... types) {
        StringBuilder text = new StringBuilder();
        FontIconType[] fontIconTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            FontIconType type = fontIconTypeArray[n2];
            text.append(type.getChar());
            ++n2;
        }
        this.setText(text.toString());
    }

    public void loadFont() {
        Map<Integer, Font> localFonts;
        if (!fonts.containsKey(this.fontFile)) {
            fonts.put(this.fontFile, new HashMap());
        }
        if (!(localFonts = fonts.get(this.fontFile)).containsKey(this.size)) {
            localFonts.put(this.size, Font.loadFont((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.fontFile), (double)this.size));
        }
        this.font = fonts.get(this.fontFile).get(this.size);
        this.setFont(this.font);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
        this.loadFont();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.setTextFill((Paint)color);
    }
}

