/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import impl.org.controlsfx.spreadsheet.FocusModelListener;
import impl.org.controlsfx.spreadsheet.TableViewSpanSelectionModel;
import java.util.Arrays;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.util.Pair;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class SpreadsheetViewSelectionModel {
    private final TableViewSpanSelectionModel selectionModel;
    private final SpreadsheetView spv;

    SpreadsheetViewSelectionModel(SpreadsheetView spv, TableViewSpanSelectionModel selectionModel) {
        this.spv = spv;
        this.selectionModel = selectionModel;
    }

    public final void clearAndSelect(int row, SpreadsheetColumn column) {
        this.selectionModel.clearAndSelect(row, column.column);
    }

    public final void select(int row, SpreadsheetColumn column) {
        this.selectionModel.select(row, column.column);
    }

    public final void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public final ObservableList<TablePosition> getSelectedCells() {
        return this.selectionModel.getSelectedCells();
    }

    public final void selectAll() {
        this.selectionModel.selectAll();
    }

    public final TablePosition getFocusedCell() {
        return this.selectionModel.getTableView().getFocusModel().getFocusedCell();
    }

    public final void focus(int row, SpreadsheetColumn column) {
        this.selectionModel.getTableView().getFocusModel().focus(row, column.column);
    }

    public final void setSelectionMode(SelectionMode value) {
        this.selectionModel.setSelectionMode(value);
    }

    public SelectionMode getSelectionMode() {
        return this.selectionModel.getSelectionMode();
    }

    public void selectCells(List<Pair<Integer, Integer>> selectedCells) {
        this.selectionModel.verifySelectedCells(selectedCells);
    }

    public void selectCells(Pair<Integer, Integer> ... selectedCells) {
        this.selectionModel.verifySelectedCells(Arrays.asList(selectedCells));
    }

    public void selectRange(int minRow, SpreadsheetColumn minColumn, int maxRow, SpreadsheetColumn maxColumn) {
        this.selectionModel.selectRange(minRow, (TableColumnBase<ObservableList<SpreadsheetCell>, ?>)minColumn.column, maxRow, (TableColumnBase<ObservableList<SpreadsheetCell>, ?>)maxColumn.column);
    }

    public void clearAndSelectLeftCell() {
        TablePosition position = this.getFocusedCell();
        int row = position.getRow();
        int column = position.getColumn();
        if (--column < 0) {
            if (row == 0) {
                ++column;
            } else {
                column = this.spv.getGrid().getColumnCount() - 1;
                --row;
            }
        }
        this.clearAndSelect(row, (SpreadsheetColumn)this.spv.getColumns().get(column));
    }

    public void clearAndSelectRightCell() {
        TablePosition position = this.getFocusedCell();
        int row = position.getRow();
        int column = position.getColumn();
        if (++column >= this.spv.getColumns().size()) {
            if (row == this.spv.getGrid().getRowCount() - 1) {
                --column;
            } else {
                column = 0;
                ++row;
            }
        }
        this.clearAndSelect(row, (SpreadsheetColumn)this.spv.getColumns().get(column));
    }

    public void clearAndSelectPreviousCell() {
        TablePosition position = this.getFocusedCell();
        int nextRow = FocusModelListener.getPreviousRowNumber(position, (TableView<ObservableList<SpreadsheetCell>>)this.selectionModel.getTableView());
        if (nextRow >= 0) {
            this.clearAndSelect(nextRow, (SpreadsheetColumn)this.spv.getColumns().get(position.getColumn()));
        }
    }

    public void clearAndSelectNextCell() {
        TablePosition position = this.getFocusedCell();
        int nextRow = FocusModelListener.getNextRowNumber(position, (TableView<ObservableList<SpreadsheetCell>>)this.selectionModel.getTableView());
        if (nextRow < this.spv.getGrid().getRowCount()) {
            this.clearAndSelect(nextRow, (SpreadsheetColumn)this.spv.getColumns().get(position.getColumn()));
        }
    }
}

