/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.cells;

import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmaster.logic.payment.NormalPayment;
import de.deadlocker8.budgetmaster.logic.payment.Payment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPayment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPaymentEntry;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import de.deadlocker8.budgetmasterclient.ui.controller.PaymentController;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import javafx.animation.FadeTransition;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.util.Duration;
import logger.Logger;
import tools.ConvertTo;
import tools.Localization;

public class PaymentCell
extends ListCell<Payment> {
    private final double HEIGHT = 30.0;
    private PaymentController paymentController;

    public PaymentCell(PaymentController paymentController) {
        this.paymentController = paymentController;
    }

    protected void updateItem(Payment item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!empty) {
            Category category = this.paymentController.getController().getCategoryHandler().getCategory(item.getCategoryID());
            HBox hbox = new HBox();
            String dateString = item.getDate();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = format.parse(dateString);
                SimpleDateFormat finalFormat = new SimpleDateFormat("dd.MM.yy");
                dateString = finalFormat.format(date);
            }
            catch (ParseException e) {
                Logger.error(e);
            }
            Label labelDate = new Label(dateString);
            labelDate.setPrefHeight(30.0);
            labelDate.setAlignment(Pos.CENTER);
            labelDate.getStyleClass().add((Object)"greylabel");
            labelDate.setStyle("-fx-font-weight: bold; -fx-font-size: 14; -fx-text-fill: #212121");
            labelDate.setMinWidth(60.0);
            hbox.getChildren().add((Object)labelDate);
            Label labelRepeating = new Label();
            if (item instanceof RepeatingPaymentEntry) {
                labelRepeating.setGraphic((Node)new FontIcon(FontIconType.CALENDAR, 18, Color.web((String)"#212121")));
            } else {
                labelRepeating.setGraphic((Node)new FontIcon(FontIconType.CALENDAR, 18, Color.TRANSPARENT));
            }
            labelRepeating.setPrefHeight(30.0);
            labelRepeating.setStyle("-fx-font-size: 15; -fx-text-fill: #212121");
            labelRepeating.setAlignment(Pos.CENTER);
            labelRepeating.getStyleClass().add((Object)"greylabel");
            hbox.getChildren().add((Object)labelRepeating);
            HBox.setMargin((Node)labelRepeating, (Insets)new Insets(0.0, 20.0, 0.0, 15.0));
            Label labelCircle = new Label(category.getName().substring(0, 1).toUpperCase());
            labelCircle.setMinWidth(30.0);
            labelCircle.setMinHeight(30.0);
            labelCircle.setAlignment(Pos.CENTER);
            labelCircle.getStyleClass().add((Object)"greylabel");
            String textColor = ConvertTo.toRGBHex(ConvertTo.getAppropriateTextColor(Color.web((String)category.getColor())));
            labelCircle.setStyle("-fx-background-color: " + category.getColor() + "; -fx-background-radius: 50%; -fx-text-fill: " + textColor + "; -fx-font-weight: bold; -fx-font-size: 18;");
            Tooltip tooltip = new Tooltip(category.getName());
            tooltip.setStyle("-fx-font-size: 14");
            labelCircle.setTooltip(tooltip);
            hbox.getChildren().add((Object)labelCircle);
            VBox vboxNameAndDescription = new VBox();
            vboxNameAndDescription.setSpacing(2.0);
            vboxNameAndDescription.setAlignment(Pos.CENTER_LEFT);
            vboxNameAndDescription.setMinHeight(42.0);
            Label labelName = new Label(item.getName());
            labelName.setStyle("-fx-font-size: 15; -fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
            labelName.setAlignment(Pos.CENTER_LEFT);
            labelName.getStyleClass().add((Object)"greylabel");
            vboxNameAndDescription.getChildren().add((Object)labelName);
            if (item.getDescription() != null && !item.getDescription().equals("")) {
                Label labelDescription = new Label(Helpers.getFlatText(item.getDescription()));
                labelDescription.setStyle("-fx-font-size: 14; -fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT) + "; -fx-font-style: italic");
                labelDescription.setAlignment(Pos.CENTER_LEFT);
                labelDescription.getStyleClass().add((Object)"greylabel");
                vboxNameAndDescription.getChildren().add((Object)labelDescription);
            }
            hbox.getChildren().add((Object)vboxNameAndDescription);
            HBox.setMargin((Node)vboxNameAndDescription, (Insets)new Insets(0.0, 0.0, 0.0, 20.0));
            Region r = new Region();
            hbox.getChildren().add((Object)r);
            HBox.setHgrow((Node)r, (Priority)Priority.ALWAYS);
            Label labelBudget = new Label(Helpers.getCurrencyString(item.getAmount(), this.paymentController.getController().getSettings().getCurrency()));
            labelBudget.setPrefHeight(30.0);
            labelBudget.setStyle("-fx-font-weight: bold; -fx-font-size: 14; -fx-text-fill: #247A2D");
            labelBudget.setAlignment(Pos.CENTER);
            labelBudget.getStyleClass().add((Object)"greylabel");
            labelBudget.setMinWidth(90.0);
            hbox.getChildren().add((Object)labelBudget);
            HBox.setMargin((Node)labelBudget, (Insets)new Insets(0.0, 0.0, 0.0, 20.0));
            if (item.isIncome()) {
                labelBudget.setText("+" + labelBudget.getText());
            } else {
                labelBudget.setText(labelBudget.getText());
                labelBudget.setStyle("-fx-font-weight: bold; -fx-font-size: 14; -fx-text-fill: #CC0000");
            }
            Button buttonDelete = new Button();
            buttonDelete.setGraphic((Node)new FontIcon(FontIconType.TRASH, 16, Color.web((String)"#212121")));
            buttonDelete.setPrefHeight(30.0);
            buttonDelete.getStyleClass().add((Object)"greylabel");
            buttonDelete.setStyle("-fx-background-color: transparent");
            buttonDelete.setOnAction(event -> {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setTitle(Localization.getString("info.title.payment.delete"));
                alert.setHeaderText("");
                alert.setContentText(Localization.getString("info.text.payment.delete"));
                Stage dialogStage = (Stage)alert.getDialogPane().getScene().getWindow();
                dialogStage.getIcons().add((Object)this.paymentController.getController().getIcon());
                dialogStage.centerOnScreen();
                if (item instanceof RepeatingPaymentEntry) {
                    alert.setContentText(Localization.getString("info.text.payment.repeating.delete"));
                    ButtonType buttonTypeOne = new ButtonType(Localization.getString("info.text.payment.repeating.delete.all"));
                    ButtonType buttonTypeTwo = new ButtonType(Localization.getString("info.text.payment.repeating.delete.futures"));
                    ButtonType buttonTypeCancel = new ButtonType(Localization.getString("cancel"), ButtonBar.ButtonData.CANCEL_CLOSE);
                    alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOne, buttonTypeTwo, buttonTypeCancel});
                    DialogPane dialogPane = alert.getDialogPane();
                    dialogPane.getButtonTypes().stream().map(arg_0 -> ((DialogPane)dialogPane).lookupButton(arg_0)).forEach(button -> button.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
                        if (KeyCode.ENTER.equals((Object)e.getCode()) && e.getTarget() instanceof Button) {
                            ((Button)e.getTarget()).fire();
                        }
                    }));
                    Optional result = alert.showAndWait();
                    if (result.get() == buttonTypeOne) {
                        this.paymentController.deleteRepeatingPayment((RepeatingPaymentEntry)item);
                    } else if (result.get() == buttonTypeTwo) {
                        this.paymentController.deleteFuturePayments((RepeatingPaymentEntry)item);
                    }
                } else {
                    Optional result = alert.showAndWait();
                    if (result.get() == ButtonType.OK) {
                        this.paymentController.deleteNormalPayment((NormalPayment)item);
                    }
                }
            });
            hbox.getChildren().add((Object)buttonDelete);
            HBox.setMargin((Node)buttonDelete, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
            if (item.getID() == -1) {
                buttonDelete.setVisible(false);
            }
            hbox.setPadding(new Insets(10.0, 8.0, 10.0, 5.0));
            Payment selectedPayment = this.paymentController.getController().getSelectedPayment();
            this.selectPayment(selectedPayment, item, (Node)hbox);
            hbox.setPadding(new Insets(8.0, 8.0, 8.0, 5.0));
            hbox.setAlignment(Pos.CENTER_LEFT);
            this.setStyle("-fx-background: transparent; -fx-border-color: #545454; -fx-border-width: 0 0 1 0");
            this.setGraphic((Node)hbox);
            this.setAlignment(Pos.CENTER);
        } else {
            this.setStyle("-fx-background: transparent");
            this.setText(null);
            this.setGraphic(null);
        }
    }

    private void selectPayment(Payment selectedPayment, Payment item, Node noteToFade) {
        if (selectedPayment == null) {
            return;
        }
        if (selectedPayment instanceof NormalPayment) {
            if (item instanceof NormalPayment) {
                if (item.getID() != selectedPayment.getID()) {
                    return;
                }
            } else {
                return;
            }
        }
        if (selectedPayment instanceof RepeatingPayment) {
            if (item instanceof RepeatingPaymentEntry) {
                RepeatingPaymentEntry itemRepeating = (RepeatingPaymentEntry)item;
                if (itemRepeating.getRepeatingPaymentID() != selectedPayment.getID()) {
                    return;
                }
            } else {
                return;
            }
        }
        FadeTransition ft = new FadeTransition(Duration.millis((double)750.0), noteToFade);
        ft.setFromValue(1.0);
        ft.setToValue(0.0);
        ft.setCycleCount(4);
        ft.setAutoReverse(true);
        ft.play();
        ft.setOnFinished(event -> this.paymentController.getController().setSelectedPayment(null));
    }
}

