/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.cells;

import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmaster.logic.payment.Payment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPayment;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import de.deadlocker8.budgetmasterclient.ui.controller.SearchController;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import logger.Logger;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import tools.ConvertTo;

public class SearchCell
extends ListCell<Payment> {
    private final double HEIGHT = 30.0;
    private SearchController searchController;

    public SearchCell(SearchController searchController) {
        this.searchController = searchController;
    }

    protected void updateItem(Payment item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!empty) {
            Category category = this.searchController.getController().getCategoryHandler().getCategory(item.getCategoryID());
            HBox hbox = new HBox();
            String dateString = item.getDate();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = format.parse(dateString);
                SimpleDateFormat finalFormat = new SimpleDateFormat("dd.MM.yy");
                dateString = finalFormat.format(date);
            }
            catch (ParseException e) {
                Logger.error(e);
            }
            Label labelDate = new Label(dateString);
            labelDate.setPrefHeight(30.0);
            labelDate.setAlignment(Pos.CENTER);
            labelDate.getStyleClass().add((Object)"greylabel");
            labelDate.setStyle("-fx-font-weight: bold; -fx-font-size: 14; -fx-text-fill: #212121");
            labelDate.setMinWidth(60.0);
            hbox.getChildren().add((Object)labelDate);
            Label labelRepeating = new Label();
            if (item instanceof RepeatingPayment) {
                labelRepeating.setGraphic((Node)new FontIcon(FontIconType.CALENDAR, 18, Color.web((String)"#212121")));
            } else {
                labelRepeating.setGraphic((Node)new FontIcon(FontIconType.CALENDAR, 18, Color.TRANSPARENT));
            }
            labelRepeating.setPrefHeight(30.0);
            labelRepeating.setStyle("-fx-font-size: 15; -fx-text-fill: #212121");
            labelRepeating.setAlignment(Pos.CENTER);
            labelRepeating.getStyleClass().add((Object)"greylabel");
            hbox.getChildren().add((Object)labelRepeating);
            HBox.setMargin((Node)labelRepeating, (Insets)new Insets(0.0, 20.0, 0.0, 15.0));
            Label labelCircle = new Label(category.getName().substring(0, 1).toUpperCase());
            labelCircle.setMinWidth(30.0);
            labelCircle.setMinHeight(30.0);
            labelCircle.setAlignment(Pos.CENTER);
            labelCircle.getStyleClass().add((Object)"greylabel");
            String textColor = ConvertTo.toRGBHex(ConvertTo.getAppropriateTextColor(Color.web((String)category.getColor())));
            labelCircle.setStyle("-fx-background-color: " + category.getColor() + "; -fx-background-radius: 50%; -fx-text-fill: " + textColor + "; -fx-font-weight: bold; -fx-font-size: 18;");
            Tooltip tooltip = new Tooltip(category.getName());
            tooltip.setStyle("-fx-font-size: 14");
            labelCircle.setTooltip(tooltip);
            hbox.getChildren().add((Object)labelCircle);
            VBox vboxNameAndDescription = new VBox();
            vboxNameAndDescription.setSpacing(2.0);
            vboxNameAndDescription.setAlignment(Pos.CENTER_LEFT);
            vboxNameAndDescription.setMinHeight(42.0);
            Label labelName = new Label(item.getName());
            labelName.setStyle("-fx-font-size: 15; -fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
            labelName.setAlignment(Pos.CENTER_LEFT);
            labelName.getStyleClass().add((Object)"greylabel");
            vboxNameAndDescription.getChildren().add((Object)labelName);
            if (item.getDescription() != null && !item.getDescription().equals("")) {
                Label labelDescription = new Label(Helpers.getFlatText(item.getDescription()));
                labelDescription.setStyle("-fx-font-size: 14; -fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT) + "; -fx-font-style: italic");
                labelDescription.setAlignment(Pos.CENTER_LEFT);
                labelDescription.getStyleClass().add((Object)"greylabel");
                vboxNameAndDescription.getChildren().add((Object)labelDescription);
            }
            hbox.getChildren().add((Object)vboxNameAndDescription);
            HBox.setMargin((Node)vboxNameAndDescription, (Insets)new Insets(0.0, 0.0, 0.0, 20.0));
            Region r = new Region();
            hbox.getChildren().add((Object)r);
            HBox.setHgrow((Node)r, (Priority)Priority.ALWAYS);
            Label labelBudget = new Label(Helpers.getCurrencyString(item.getAmount(), this.searchController.getController().getSettings().getCurrency()));
            labelBudget.setPrefHeight(30.0);
            labelBudget.setStyle("-fx-font-weight: bold; -fx-font-size: 14; -fx-text-fill: #247A2D");
            labelBudget.setAlignment(Pos.CENTER);
            labelBudget.getStyleClass().add((Object)"greylabel");
            labelBudget.setMinWidth(90.0);
            hbox.getChildren().add((Object)labelBudget);
            HBox.setMargin((Node)labelBudget, (Insets)new Insets(0.0, 0.0, 0.0, 20.0));
            if (item.isIncome()) {
                labelBudget.setText("+" + labelBudget.getText());
            } else {
                labelBudget.setText(labelBudget.getText());
                labelBudget.setStyle("-fx-font-weight: bold; -fx-font-size: 14; -fx-text-fill: #CC0000");
            }
            Button buttonGoto = new Button();
            buttonGoto.setGraphic((Node)new FontIcon(FontIconType.EXTERNAL_LINK_SQUARE, 16, Color.web((String)"#212121")));
            buttonGoto.setPrefHeight(30.0);
            buttonGoto.getStyleClass().add((Object)"greylabel");
            buttonGoto.setStyle("-fx-background-color: transparent");
            buttonGoto.setOnAction(event -> {
                DateTime newDate = DateTime.parse(item.getDate(), DateTimeFormat.forPattern("YYYY-MM-dd"));
                this.searchController.getController().setSelectedPayment(item);
                this.searchController.getController().setDate(newDate);
                this.searchController.cancel();
            });
            hbox.getChildren().add((Object)buttonGoto);
            HBox.setMargin((Node)buttonGoto, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
            hbox.setPadding(new Insets(8.0, 8.0, 8.0, 5.0));
            hbox.setAlignment(Pos.CENTER_LEFT);
            this.setStyle("-fx-background: transparent; -fx-border-color: #545454; -fx-border-width: 0 0 1 0");
            this.setGraphic((Node)hbox);
            this.setAlignment(Pos.CENTER);
        } else {
            this.setStyle("-fx-background: transparent");
            this.setText(null);
            this.setGraphic(null);
        }
    }
}

