/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.cells;

import de.deadlocker8.budgetmaster.logic.category.Category;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import tools.ConvertTo;

public class SmallCategoryCell
extends ListCell<Category> {
    private final double HEIGHT = 30.0;

    protected void updateItem(Category item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!empty) {
            HBox hbox = new HBox();
            Label labelCircle = new Label(item.getName().substring(0, 1).toUpperCase());
            labelCircle.setPrefWidth(30.0);
            labelCircle.setPrefHeight(30.0);
            labelCircle.setAlignment(Pos.CENTER);
            String textColor = ConvertTo.toRGBHex(ConvertTo.getAppropriateTextColor(Color.web((String)item.getColor())));
            labelCircle.setStyle("-fx-background-color: " + item.getColor() + "; -fx-background-radius: 50%; -fx-text-fill: " + textColor + "; -fx-font-weight: bold; -fx-font-size: 15;");
            hbox.getChildren().add((Object)labelCircle);
            Label labelName = new Label(item.getName());
            labelName.setPrefHeight(30.0);
            labelName.setStyle("-fx-font-weight: bold; -fx-font-size: 14; -fx-text-fill: #212121");
            labelName.setAlignment(Pos.CENTER);
            hbox.getChildren().add((Object)labelName);
            HBox.setMargin((Node)labelName, (Insets)new Insets(0.0, 0.0, 0.0, 20.0));
            hbox.setPadding(new Insets(3.0));
            this.setStyle("-fx-background: transparent; -fx-border-color: #545454; -fx-border-width: 0 0 1 0");
            this.setGraphic((Node)hbox);
            this.setAlignment(Pos.CENTER);
        } else {
            this.setStyle("-fx-background: transparent");
            this.setText(null);
            this.setGraphic(null);
        }
    }
}

