/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.commandLine;

import de.deadlocker8.budgetmasterclient.ui.commandLine.CommandLine;
import de.deadlocker8.budgetmasterclient.ui.commandLine.HistoryEntry;
import de.deadlocker8.budgetmasterclient.ui.commandLine.HistoryType;
import de.deadlocker8.budgetmasterclient.ui.commandLine.commands.Command;
import de.deadlocker8.budgetmasterclient.ui.commandLine.commands.PossibleCommands;
import java.util.ArrayList;
import java.util.Comparator;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class CommandLineController {
    @FXML
    private TextArea textareaHistory;
    @FXML
    private TextField textfieldInput;
    private CommandLine commandLine;

    public void init(CommandLine commandLine) {
        this.commandLine = commandLine;
        commandLine.getBundle().setController(this);
        commandLine.getBundle().setLanguageBundle(commandLine.getLanguageBundle());
        this.textareaHistory.setEditable(false);
        this.textareaHistory.setWrapText(true);
        this.textfieldInput.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    CommandLineController.this.parse();
                }
                if (event.getCode().equals((Object)KeyCode.UP)) {
                    CommandLineController.this.showLastCommand();
                }
                if (event.getCode().equals((Object)KeyCode.ESCAPE)) {
                    CommandLineController.this.clearConsole();
                }
                if (event.getCode().equals((Object)KeyCode.TAB)) {
                    CommandLineController.this.autocomplete();
                    event.consume();
                }
            }
        });
        this.printPrompt();
    }

    public void printPrompt() {
        this.setConsoleText();
        this.clearConsole();
    }

    public void print(String message) {
        this.commandLine.history.add(new HistoryEntry(HistoryType.MESSAGE, message));
        this.setConsoleText();
        this.printPrompt();
    }

    public void clearHistoryLog() {
        this.textareaHistory.setText("");
    }

    public void clearHistory() {
        this.commandLine.history = new ArrayList();
    }

    public void clearConsole() {
        this.textfieldInput.setText("");
        this.textfieldInput.requestFocus();
    }

    private void setConsoleText() {
        this.clearHistoryLog();
        StringBuilder sb = new StringBuilder();
        boolean printedLastEntry = false;
        for (int i = 0; i < this.commandLine.history.size(); ++i) {
            HistoryEntry currentEntry = this.commandLine.history.get(i);
            if (currentEntry.getType().equals((Object)HistoryType.COMMAND)) {
                if (printedLastEntry) {
                    sb.append("\n");
                }
                sb.append(this.commandLine.getPromptText());
                sb.append(" ");
                sb.append(currentEntry.getText());
                printedLastEntry = true;
                continue;
            }
            if (i != 0) {
                sb.append("\n");
            }
            sb.append(currentEntry.getText());
            printedLastEntry = true;
        }
        this.textareaHistory.setText(sb.toString());
        this.textareaHistory.positionCaret(sb.toString().length());
    }

    private boolean executeCommand(String[] command) {
        for (Command cmd : PossibleCommands.possibleCommands) {
            if (!cmd.getKeyword().equals(command[0])) continue;
            cmd.execute(command, this.commandLine.getBundle());
            return true;
        }
        return false;
    }

    private void parse() {
        String input = this.textfieldInput.getText().replace("\n", "");
        if (input.equals("")) {
            this.printPrompt();
            return;
        }
        this.commandLine.globalHistory.add(new HistoryEntry(HistoryType.COMMAND, input));
        this.commandLine.history.add(new HistoryEntry(HistoryType.COMMAND, input));
        this.commandLine.lastShownCommand = -1;
        String[] command = input.split(" ");
        if (!this.executeCommand(command)) {
            this.print(this.commandLine.getLanguageBundle().getString("error.unknown.command"));
        } else {
            this.printPrompt();
        }
    }

    private void showLastCommand() {
        if (this.commandLine.globalHistory.size() > 0) {
            if (this.commandLine.lastShownCommand <= 0) {
                this.textfieldInput.setText(this.commandLine.globalHistory.get(this.commandLine.globalHistory.size() - 1).getText());
                this.commandLine.lastShownCommand = this.commandLine.globalHistory.size() - 1;
            } else {
                this.textfieldInput.setText(this.commandLine.globalHistory.get(this.commandLine.lastShownCommand - 1).getText());
                --this.commandLine.lastShownCommand;
            }
            Platform.runLater(() -> this.textfieldInput.positionCaret(this.textfieldInput.getText().length()));
        }
    }

    private void autocomplete() {
        String input = this.textfieldInput.getText().replace("\n", "");
        if (input.equals("")) {
            return;
        }
        ArrayList<Command> commands = PossibleCommands.possibleCommands;
        ArrayList<Command> filteredCommands = new ArrayList<Command>();
        for (Command currentCommand : commands) {
            if (!currentCommand.getKeyword().startsWith(input)) continue;
            filteredCommands.add(currentCommand);
        }
        filteredCommands.sort(new Comparator<Command>(){

            @Override
            public int compare(Command o1, Command o2) {
                return o1.keyword.compareTo(o2.keyword);
            }
        });
        if (filteredCommands.size() == 1) {
            this.textfieldInput.setText(((Command)filteredCommands.get(0)).getKeyword());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(">>> Possible commands for \"" + input + "\":\n");
            for (int i = 0; i < filteredCommands.size(); ++i) {
                sb.append(((Command)filteredCommands.get((int)i)).keyword);
                if (i == filteredCommands.size() - 1) continue;
                sb.append("\n");
            }
            this.print(sb.toString());
            this.textfieldInput.setText(input);
        }
        Platform.runLater(() -> this.textfieldInput.positionCaret(this.textfieldInput.getText().length()));
    }
}

