/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.commandLine.commands;

import de.deadlocker8.budgetmasterclient.ui.commandLine.CommandBundle;
import de.deadlocker8.budgetmasterclient.ui.commandLine.commands.Command;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import tools.Localization;
import tools.PathUtils;

public class CommandOpen
extends Command {
    public CommandOpen() {
        this.keyword = "open";
        this.numberOfParams = 1;
        this.helptText = "help.open";
    }

    @Override
    public void execute(String[] command, CommandBundle bundle) {
        if (!this.isValid(command)) {
            bundle.getController().print(bundle.getString("error.invalid.arguments"));
            return;
        }
        if (!command[1].equals("settings")) {
            bundle.getController().print(bundle.getString("error.invalid.parameter", command[1], this.keyword));
            return;
        }
        try {
            File folder = Paths.get(PathUtils.getOSindependentPath() + Localization.getString("folder"), new String[0]).toFile();
            Desktop.getDesktop().open(folder);
            bundle.getController().print(bundle.getString("open.success", folder.getAbsolutePath()));
        }
        catch (IOException e) {
            bundle.getController().print(e.getMessage());
        }
    }
}

