/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmaster.logic.FilterSettings;
import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmaster.logic.serverconnection.ExceptionHandler;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerTagConnection;
import de.deadlocker8.budgetmaster.logic.tag.Tag;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmasterclient.ui.Styleable;
import de.deadlocker8.budgetmasterclient.ui.controller.BaseController;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import logger.Logger;
import tools.ConvertTo;
import tools.Localization;

public class FilterController
extends BaseController
implements Styleable {
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private VBox vboxMain;
    @FXML
    private CheckBox checkBoxIncome;
    @FXML
    private CheckBox checkBoxPayment;
    @FXML
    private CheckBox checkBoxNoRepeating;
    @FXML
    private CheckBox checkBoxMonthlyRepeating;
    @FXML
    private CheckBox checkBoxRepeatEveryXDays;
    @FXML
    private VBox vboxCategories;
    @FXML
    private TextField textFieldSearch;
    @FXML
    private VBox vboxTags;
    @FXML
    private Button buttonCancel;
    @FXML
    private Button buttonReset;
    @FXML
    private Button buttonFilter;
    @FXML
    private Button buttonCategoryAll;
    @FXML
    private Button buttonCategoryNone;
    @FXML
    private Button buttonTagsAll;
    @FXML
    private Button buttonTagsNone;
    @FXML
    private Label labelSeparator;
    @FXML
    private Label labelSeparatorHorizontalLeft;
    @FXML
    private Label labelSeparatorHorizontalRight;
    private Stage parentStage;
    private Controller controller;
    private FilterSettings filterSetttings;
    private ArrayList<Tag> allTags;

    public FilterController(Stage parentStage, Controller controller, FilterSettings filterSettings) {
        this.parentStage = parentStage;
        this.controller = controller;
        this.filterSetttings = filterSettings;
        this.load("/de/deadlocker8/budgetmaster/ui/fxml/FilterGUI.fxml", Localization.getBundle());
        this.getStage().showAndWait();
    }

    @Override
    public void initStage(Stage stage) {
        stage.initOwner((Window)this.parentStage);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setTitle(Localization.getString("title.filter"));
        stage.getIcons().add((Object)this.controller.getIcon());
        stage.setResizable(true);
        stage.setMinHeight(600.0);
        stage.setMinWidth(475.0);
    }

    @Override
    public void init() {
        this.applyStyle();
        for (Category currentCategory : this.controller.getCategoryHandler().getCategories()) {
            CheckBox newCheckBox = new CheckBox();
            newCheckBox.setText(currentCategory.getName());
            newCheckBox.setUserData((Object)currentCategory.getID());
            newCheckBox.setStyle("-fx-font-size: 14;");
            this.vboxCategories.getChildren().add((Object)newCheckBox);
        }
        try {
            ServerTagConnection connection = new ServerTagConnection(this.controller.getSettings());
            this.allTags = connection.getTags();
            for (Tag currentTag : this.allTags) {
                CheckBox newCheckBox = new CheckBox();
                newCheckBox.setText(currentTag.getName());
                newCheckBox.setUserData((Object)currentTag.getID());
                newCheckBox.setStyle("-fx-font-size: 14;");
                this.vboxTags.getChildren().add((Object)newCheckBox);
            }
        }
        catch (Exception e) {
            Logger.error(e);
            this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
            return;
        }
        this.textFieldSearch.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.filter();
            }
        });
        this.vboxMain.prefWidthProperty().bind((ObservableValue)this.scrollPane.widthProperty().subtract(5));
        this.vboxMain.prefHeightProperty().bind((ObservableValue)this.scrollPane.heightProperty().subtract(5));
        this.preselect();
    }

    private void preselect() {
        this.checkBoxIncome.setSelected(this.filterSetttings.isIncomeAllowed());
        this.checkBoxPayment.setSelected(this.filterSetttings.isPaymentAllowed());
        this.checkBoxNoRepeating.setSelected(this.filterSetttings.isNoRepeatingAllowed());
        this.checkBoxMonthlyRepeating.setSelected(this.filterSetttings.isMonthlyRepeatingAllowed());
        this.checkBoxRepeatEveryXDays.setSelected(this.filterSetttings.isRepeatingEveryXDaysAllowed());
        ArrayList<Integer> allowedCategoryIDs = this.filterSetttings.getAllowedCategoryIDs();
        for (Node node : this.vboxCategories.getChildren()) {
            CheckBox currentCheckBox = (CheckBox)node;
            if (allowedCategoryIDs != null && !allowedCategoryIDs.contains(currentCheckBox.getUserData())) continue;
            currentCheckBox.setSelected(true);
        }
        ArrayList<Integer> allowedTagIDs = this.filterSetttings.getAllowedTagIDs();
        for (Node node : this.vboxTags.getChildren()) {
            CheckBox currentCheckBox = (CheckBox)node;
            if (allowedTagIDs != null && !allowedTagIDs.contains(currentCheckBox.getUserData())) continue;
            currentCheckBox.setSelected(true);
        }
        this.textFieldSearch.setText(this.filterSetttings.getName());
    }

    public void filter() {
        String name;
        boolean isIncomeAllowed = this.checkBoxIncome.isSelected();
        boolean isPaymentAllowed = this.checkBoxPayment.isSelected();
        boolean isNoRepeatingAllowed = this.checkBoxNoRepeating.isSelected();
        boolean isMonthlyRepeatingAllowed = this.checkBoxMonthlyRepeating.isSelected();
        boolean isRepeatingEveryXDaysAllowed = this.checkBoxRepeatEveryXDays.isSelected();
        ArrayList<Integer> allowedCategoryIDs = new ArrayList<Integer>();
        for (Node node : this.vboxCategories.getChildren()) {
            CheckBox currentCheckBox = (CheckBox)node;
            if (!currentCheckBox.isSelected()) continue;
            allowedCategoryIDs.add((Integer)currentCheckBox.getUserData());
        }
        if (allowedCategoryIDs.size() == this.controller.getCategoryHandler().getCategories().size()) {
            allowedCategoryIDs = null;
        }
        if ((name = this.textFieldSearch.getText()) != null && name.equals("")) {
            name = null;
        }
        ArrayList<Integer> allowedTagIDs = new ArrayList<Integer>();
        for (Node node : this.vboxTags.getChildren()) {
            CheckBox currentCheckBox = (CheckBox)node;
            if (!currentCheckBox.isSelected()) continue;
            allowedTagIDs.add((Integer)currentCheckBox.getUserData());
        }
        if (allowedTagIDs.size() == this.allTags.size()) {
            allowedTagIDs = null;
        }
        FilterSettings newFilterSettings = new FilterSettings(isIncomeAllowed, isPaymentAllowed, isNoRepeatingAllowed, isMonthlyRepeatingAllowed, isRepeatingEveryXDaysAllowed, allowedCategoryIDs, allowedTagIDs, name);
        this.controller.setFilterSettings(newFilterSettings);
        this.controller.refresh(newFilterSettings);
        this.getStage().close();
    }

    public void reset() {
        this.filterSetttings = new FilterSettings();
        this.getStage().close();
        this.controller.setFilterSettings(this.filterSetttings);
        this.controller.refresh(this.filterSetttings);
    }

    public void cancel() {
        this.getStage().close();
    }

    public void enableAllCategories() {
        for (Node node : this.vboxCategories.getChildren()) {
            ((CheckBox)node).setSelected(true);
        }
    }

    public void disableAllCategories() {
        for (Node node : this.vboxCategories.getChildren()) {
            ((CheckBox)node).setSelected(false);
        }
    }

    public void enableAllTags() {
        for (Node node : this.vboxTags.getChildren()) {
            ((CheckBox)node).setSelected(true);
        }
    }

    public void disableAllTags() {
        for (Node node : this.vboxTags.getChildren()) {
            ((CheckBox)node).setSelected(false);
        }
    }

    @Override
    public void applyStyle() {
        this.buttonCancel.setGraphic((Node)new FontIcon(FontIconType.TIMES, 17, Color.WHITE));
        this.buttonReset.setGraphic((Node)new FontIcon(FontIconType.UNDO, 17, Color.WHITE));
        this.buttonFilter.setGraphic((Node)new FontIcon(FontIconType.FILTER, 17, Color.WHITE));
        this.scrollPane.setStyle("-fx-background-color: transparent");
        this.labelSeparator.setStyle("-fx-background-color: #CCCCCC;");
        this.labelSeparator.setMinWidth(1.0);
        this.labelSeparator.setMaxWidth(1.0);
        this.labelSeparatorHorizontalLeft.setStyle("-fx-background-color: #CCCCCC;");
        this.labelSeparatorHorizontalLeft.setMinHeight(1.0);
        this.labelSeparatorHorizontalLeft.setMaxHeight(1.0);
        this.labelSeparatorHorizontalRight.setStyle("-fx-background-color: #CCCCCC;");
        this.labelSeparatorHorizontalRight.setMinHeight(1.0);
        this.labelSeparatorHorizontalRight.setMaxHeight(1.0);
        this.buttonCancel.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 15;");
        this.buttonReset.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 15;");
        this.buttonFilter.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 15;");
        this.buttonCategoryAll.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 13;");
        this.buttonCategoryNone.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 13;");
        this.buttonTagsAll.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 13;");
        this.buttonTagsNone.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 13;");
    }
}

