/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller.settings;

import de.deadlocker8.budgetmaster.logic.ServerType;
import de.deadlocker8.budgetmaster.logic.Settings;
import de.deadlocker8.budgetmaster.logic.updater.Updater;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.FileHelper;
import de.deadlocker8.budgetmaster.logic.utils.LanguageType;
import de.deadlocker8.budgetmasterclient.ui.RestartHandler;
import de.deadlocker8.budgetmasterclient.ui.cells.LanguageCell;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import de.deadlocker8.budgetmasterclient.ui.controller.settings.SettingsController;
import java.io.IOException;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.stage.Window;
import logger.Logger;
import tools.AlertGenerator;
import tools.ConvertTo;
import tools.HashUtils;
import tools.Localization;

public class OnlineServerSettingsController
extends SettingsController {
    @FXML
    private AnchorPane anchorPaneMain;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private HBox hboxSettings;
    @FXML
    private ToggleButton toggleButtonOnline;
    @FXML
    private ToggleButton toggleButtonLocal;
    @FXML
    private Label labelClientSecret;
    @FXML
    private TextField textFieldClientSecret;
    @FXML
    private TextField textFieldURL;
    @FXML
    private Label labelURL;
    @FXML
    private TextField textFieldSecret;
    @FXML
    private Label labelSecret;
    @FXML
    private TextField textFieldCurrency;
    @FXML
    private Label labelCurrency;
    @FXML
    private Button buttonSave;
    @FXML
    private Button buttonExportDB;
    @FXML
    private Button buttonImportDB;
    @FXML
    private Button buttonDeleteDB;
    @FXML
    private RadioButton radioButtonRestActivated;
    @FXML
    private RadioButton radioButtonRestDeactivated;
    @FXML
    private TextArea textAreaTrustedHosts;
    @FXML
    private ComboBox<LanguageType> comboBoxLanguage;
    @FXML
    private CheckBox checkboxEnableAutoUpdate;
    @FXML
    private Button buttonSearchUpdates;
    @FXML
    private Label labelCurrentVersion;
    @FXML
    private Label labelLatestVersion;
    private LanguageType previousLanguage;

    @Override
    public void init(Controller controller) {
        this.controller = controller;
        ToggleGroup toggleGroupServerType = new ToggleGroup();
        this.toggleButtonOnline.setToggleGroup(toggleGroupServerType);
        this.toggleButtonLocal.setToggleGroup(toggleGroupServerType);
        this.toggleButtonLocal.setOnAction(event -> {
            controller.getSettings().setServerType(ServerType.LOCAL);
            controller.loadSettingsTab();
        });
        this.textFieldClientSecret.setText("******");
        this.comboBoxLanguage.setCellFactory(view -> new LanguageCell(true));
        this.comboBoxLanguage.getItems().addAll((Object[])LanguageType.values());
        this.comboBoxLanguage.setButtonCell((ListCell)new LanguageCell(false));
        this.comboBoxLanguage.setValue((Object)LanguageType.ENGLISH);
        this.previousLanguage = LanguageType.ENGLISH;
        this.checkboxEnableAutoUpdate.setSelected(true);
        this.prefill();
        this.applyStyle();
        this.textFieldURL.setPromptText(Localization.getString("url.placeholder"));
        this.textFieldCurrency.setPromptText(Localization.getString("currency.placeholder"));
        this.textAreaTrustedHosts.setPromptText(Localization.getString("trusted.hosts.placeholder"));
        ToggleGroup toggleGroup = new ToggleGroup();
        this.radioButtonRestActivated.setToggleGroup(toggleGroup);
        this.radioButtonRestDeactivated.setToggleGroup(toggleGroup);
        this.hboxSettings.prefWidthProperty().bind((ObservableValue)this.scrollPane.widthProperty().subtract(25));
        this.refreshLabelsUpdate();
        if (controller.checkSettings()) {
            controller.refresh(controller.getFilterSettings());
        }
    }

    @Override
    public void prefill() {
        if (this.controller.getSettings().isComplete()) {
            this.textFieldURL.setText(this.controller.getSettings().getUrl());
            this.textFieldSecret.setText("******");
            this.textFieldCurrency.setText(this.controller.getSettings().getCurrency());
        }
        if (this.controller.getSettings().isRestActivated()) {
            this.radioButtonRestActivated.setSelected(true);
        } else {
            this.radioButtonRestDeactivated.setSelected(true);
        }
        this.setTextAreaTrustedHosts(this.controller.getSettings().getTrustedHosts());
        if (this.controller.getSettings().getLanguage() != null) {
            LanguageType language = this.controller.getSettings().getLanguage();
            this.comboBoxLanguage.setValue((Object)language);
            this.previousLanguage = language;
        }
        this.checkboxEnableAutoUpdate.setSelected(this.controller.getSettings().isAutoUpdateCheckEnabled());
    }

    @Override
    void refreshLabelsUpdate() {
        Updater updater = this.controller.getUpdater();
        this.labelCurrentVersion.setText(Localization.getString("version.name"));
        this.labelLatestVersion.setText(updater.getLatestVersion().getVersionName());
    }

    private void setTextAreaTrustedHosts(ArrayList<String> trustedHosts) {
        StringBuilder trustedHostsString = new StringBuilder();
        if (trustedHosts != null) {
            for (String currentHost : trustedHosts) {
                trustedHostsString.append(currentHost);
                trustedHostsString.append("\n");
            }
            this.textAreaTrustedHosts.setText(trustedHostsString.toString());
        } else {
            this.textAreaTrustedHosts.setText("");
        }
    }

    @Override
    public void save() {
        String[] trustedHostsArray;
        String clientSecret = this.textFieldClientSecret.getText();
        String url = this.textFieldURL.getText();
        String secret = this.textFieldSecret.getText();
        String currency = this.textFieldCurrency.getText();
        if (clientSecret == null || clientSecret.trim().equals("")) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.empty.secret.client"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
            return;
        }
        clientSecret = clientSecret.trim();
        if (url == null || url.trim().equals("")) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.empty.url"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
            return;
        }
        url = url.trim();
        if (secret == null || secret.trim().equals("")) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.empty.secret.server"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
            return;
        }
        secret = secret.trim();
        if (currency == null || currency.trim().equals("")) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.empty.currency"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
            return;
        }
        currency = currency.trim();
        ArrayList<String> trustedHosts = new ArrayList<String>();
        String trustedHostText = this.textAreaTrustedHosts.getText();
        for (String currentHost : trustedHostsArray = trustedHostText.split("\n")) {
            if ((currentHost = currentHost.trim()).equals("")) continue;
            trustedHosts.add(currentHost);
        }
        this.setTextAreaTrustedHosts(trustedHosts);
        if (this.controller.getSettings().isComplete()) {
            if (!clientSecret.equals("******")) {
                this.controller.getSettings().setClientSecret(HashUtils.hash(clientSecret, "ny9/Y+G|WrJ,82|oIYQQ X %i-sq#4,uA-qKPtwFPnw+s(k2`rV)^-a1|t{D3Z>S"));
            }
            if (!secret.equals("******")) {
                this.controller.getSettings().setSecret(HashUtils.hash(secret, "ny9/Y+G|WrJ,82|oIYQQ X %i-sq#4,uA-qKPtwFPnw+s(k2`rV)^-a1|t{D3Z>S"));
            }
            this.controller.getSettings().setUrl(url);
            this.controller.getSettings().setCurrency(currency);
            this.controller.getSettings().setRestActivated(this.radioButtonRestActivated.isSelected());
            this.controller.getSettings().setTrustedHosts(trustedHosts);
            this.controller.getSettings().setLanguage((LanguageType)((Object)this.comboBoxLanguage.getValue()));
            this.controller.getSettings().setAutoUpdateCheckEnabled(this.checkboxEnableAutoUpdate.isSelected());
            this.controller.getSettings().setServerType(ServerType.ONLINE);
        } else {
            Settings settings = new Settings();
            if (!clientSecret.equals("******")) {
                settings.setClientSecret(HashUtils.hash(clientSecret, "ny9/Y+G|WrJ,82|oIYQQ X %i-sq#4,uA-qKPtwFPnw+s(k2`rV)^-a1|t{D3Z>S"));
            } else {
                settings.setClientSecret(this.controller.getSettings().getClientSecret());
            }
            if (!secret.equals("******")) {
                settings.setSecret(HashUtils.hash(secret, "ny9/Y+G|WrJ,82|oIYQQ X %i-sq#4,uA-qKPtwFPnw+s(k2`rV)^-a1|t{D3Z>S"));
            } else {
                settings.setSecret(this.controller.getSettings().getSecret());
            }
            settings.setUrl(url);
            settings.setCurrency(currency);
            settings.setRestActivated(this.radioButtonRestActivated.isSelected());
            settings.setTrustedHosts(trustedHosts);
            settings.setLanguage((LanguageType)((Object)this.comboBoxLanguage.getValue()));
            settings.setAutoUpdateCheckEnabled(this.checkboxEnableAutoUpdate.isSelected());
            settings.setServerType(ServerType.ONLINE);
            this.controller.setSettings(settings);
        }
        try {
            FileHelper.saveSettings(this.controller.getSettings());
        }
        catch (IOException e) {
            Logger.error(e);
            AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.settings.save"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
        }
        this.textFieldClientSecret.setText("******");
        this.textFieldSecret.setText("******");
        RestartHandler restartHandler = new RestartHandler(this.controller);
        restartHandler.handleRestart(this.previousLanguage);
        this.refreshLabelsUpdate();
    }

    @Override
    public void applyStyle() {
        this.anchorPaneMain.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND));
        this.scrollPane.setStyle("-fx-background-color: transparent");
        this.toggleButtonOnline.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_DARK_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14; -fx-background-radius: 3 0 0 3; -fx-effect: innershadow(gaussian, rgba(0,0,0,0.7), 10,0,0,0);");
        this.toggleButtonLocal.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14; -fx-background-radius: 0 3 3 0");
        this.labelClientSecret.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.labelSecret.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.labelURL.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.labelCurrency.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.buttonSave.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 16;");
        this.buttonExportDB.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14;");
        this.buttonImportDB.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14;");
        this.buttonDeleteDB.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_RED) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14;");
        this.buttonSearchUpdates.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14;");
    }
}

