/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.utils;

import de.deadlocker8.budgetmaster.logic.database.Database;
import de.deadlocker8.budgetmaster.logic.serverconnection.ExceptionHandler;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnection;
import de.deadlocker8.budgetmaster.logic.utils.FileHelper;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import de.deadlocker8.budgetmasterclient.utils.DatabaseDeleter;
import de.deadlocker8.budgetmasterclient.utils.LoadingModal;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import logger.Logger;
import tools.AlertGenerator;
import tools.Localization;
import tools.Worker;

public class DatabaseImporter {
    private Controller controller;

    public DatabaseImporter(Controller controller) {
        this.controller = controller;
    }

    public void importDatabase() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle(Localization.getString("info.title.database.import.dialog"));
        alert.setHeaderText("");
        alert.setContentText(Localization.getString("info.text.database.import.dialog"));
        Stage dialogStage = (Stage)alert.getDialogPane().getScene().getWindow();
        dialogStage.getIcons().add((Object)this.controller.getIcon());
        dialogStage.initOwner((Window)this.controller.getStage());
        ButtonType buttonTypeDelete = new ButtonType(Localization.getString("info.text.database.import.dialog.delete"));
        ButtonType buttonTypeAppend = new ButtonType(Localization.getString("info.text.database.import.dialog.append"));
        ButtonType buttonTypeCancel = new ButtonType(Localization.getString("cancel"), ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeDelete, buttonTypeAppend, buttonTypeCancel});
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.getButtonTypes().stream().map(arg_0 -> ((DialogPane)dialogPane).lookupButton(arg_0)).forEach(button -> button.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER.equals((Object)event.getCode()) && event.getTarget() instanceof Button) {
                ((Button)event.getTarget()).fire();
            }
        }));
        Optional result = alert.showAndWait();
        if (result.get() == buttonTypeDelete) {
            DatabaseDeleter deleter = new DatabaseDeleter(this.controller);
            deleter.deleteDatabase(true);
        } else if (result.get() == buttonTypeAppend) {
            this.importDB();
        }
    }

    public void importDB() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(Localization.getString("title.database.import"));
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("JSON (*.json)", new String[]{"*.json"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showOpenDialog((Window)this.controller.getStage());
        if (file != null) {
            Database database;
            try {
                database = FileHelper.loadDatabaseJSON(file);
                if (database.getCategories() == null || database.getNormalPayments() == null || database.getRepeatingPayments() == null || database.getTags() == null || database.getTagMatches() == null) {
                    AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.database.import.wrong.file"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
                    return;
                }
            }
            catch (IOException e1) {
                Logger.error(e1);
                AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.database.import"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
                return;
            }
            LoadingModal.showModal(this.controller, Localization.getString("title.modal"), Localization.getString("load.database.import"), this.controller.getStage(), this.controller.getIcon());
            Worker.runLater(() -> {
                try {
                    ServerConnection connection = new ServerConnection(this.controller.getSettings());
                    connection.importDatabase(database);
                    Platform.runLater(() -> {
                        LoadingModal.closeModal();
                        AlertGenerator.showAlert(Alert.AlertType.INFORMATION, Localization.getString("info.title.database.import"), "", Localization.getString("info.text.database.import"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
                        this.controller.refresh(this.controller.getFilterSettings());
                    });
                }
                catch (Exception e) {
                    Logger.error(e);
                    Platform.runLater(() -> {
                        LoadingModal.closeModal();
                        this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
                    });
                }
            });
        } else {
            this.controller.refresh(this.controller.getFilterSettings());
        }
    }
}

