/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class Read {
    public static String[] readFromFile(String directory) {
        try {
            String line;
            FileInputStream fis = new FileInputStream(directory);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            ArrayList<String> list = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
            String[] lines = list.toArray(new String[list.size()]);
            reader.close();
            return lines;
        }
        catch (IOException e) {
            System.err.println("Fehler beim Einlesen der Datei   " + directory);
            return null;
        }
    }

    public static String[] readFromJar(String directory) {
        try {
            String line;
            InputStream input = Read.class.getResourceAsStream("/" + directory);
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            ArrayList<String> list = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
            String[] lines = list.toArray(new String[list.size()]);
            reader.close();
            return lines;
        }
        catch (IOException e) {
            System.err.println("Fehler beim Einlesen der Datei   " + directory);
            return null;
        }
    }

    public static String[] readErrorCodesFromJar() {
        try {
            String line;
            InputStream input = Read.class.getResourceAsStream("/errorCodes");
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            ArrayList<String> list = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
            String[] lines = list.toArray(new String[list.size()]);
            reader.close();
            return lines;
        }
        catch (IOException e) {
            System.err.println("Fehler beim Einlesen der Fehlercodedatei!");
            return null;
        }
    }

    public static String[] readFromURL(String url) throws Exception {
        String line;
        URL webseite = new URL(url);
        URLConnection connection = webseite.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        ArrayList<String> text = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            text.add(line);
        }
        String[] lines = text.toArray(new String[text.size()]);
        br.close();
        return lines;
    }

    public static String getStringFromInputStream(InputStream is) {
        StringBuilder sb;
        block15: {
            BufferedReader br = null;
            sb = new StringBuilder();
            try {
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

