/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.devapi;

import com.mysql.cj.api.x.ColumnDefinition;
import com.mysql.cj.api.x.Type;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.util.StringUtils;
import java.util.Arrays;
import java.util.stream.Collectors;

public abstract class AbstractColumnDef<T extends ColumnDefinition<T>>
implements ColumnDefinition<T> {
    protected String name;
    protected Type type;
    protected Number length;
    protected Boolean notNull;
    protected boolean uniqueIndex = false;
    protected boolean primaryKey = false;
    protected String comment = null;
    protected Boolean unsigned;
    protected Number decimals;
    protected String charset = null;
    protected String collation = null;
    protected Boolean binary;
    protected String[] values;

    abstract T self();

    @Override
    public T notNull() {
        this.notNull = true;
        return this.self();
    }

    @Override
    public T uniqueIndex() {
        this.uniqueIndex = true;
        return this.self();
    }

    @Override
    public T primaryKey() {
        this.primaryKey = true;
        return this.self();
    }

    @Override
    public T comment(String cmt) {
        this.comment = cmt;
        return this.self();
    }

    @Override
    public T unsigned() {
        this.unsigned = true;
        return this.self();
    }

    @Override
    public T decimals(int val) {
        this.decimals = val;
        return this.self();
    }

    @Override
    public T charset(String charsetName) {
        this.charset = charsetName;
        return this.self();
    }

    @Override
    public T collation(String collationName) {
        this.collation = collationName;
        return this.self();
    }

    @Override
    public T binary() {
        this.binary = true;
        return this.self();
    }

    @Override
    public T values(String ... val) {
        this.values = val;
        return this.self();
    }

    protected String getMysqlType() {
        String mysqlTypeName;
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case STRING: {
                mysqlTypeName = "VARCHAR";
                break;
            }
            case BYTES: {
                mysqlTypeName = "VARBINARY";
                break;
            }
            default: {
                mysqlTypeName = this.type.name();
            }
        }
        sb.append(mysqlTypeName);
        if (this.length != null) {
            switch (this.type) {
                case JSON: 
                case GEOMETRY: {
                    throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ColumnDefinition.0", new String[]{"Length parameter", mysqlTypeName, this.name}));
                }
            }
            sb.append("(").append(this.length);
            if (this.decimals != null) {
                switch (this.type) {
                    case DECIMAL: 
                    case DOUBLE: 
                    case FLOAT: {
                        sb.append(", ").append(this.decimals);
                        break;
                    }
                    default: {
                        throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ColumnDefinition.0", new String[]{"Decimals parameter", mysqlTypeName, this.name}));
                    }
                }
            }
            sb.append(")");
        } else {
            switch (this.type) {
                case ENUM: 
                case SET: {
                    sb.append(Arrays.stream(this.values).map(v -> StringUtils.quoteIdentifier(v, "'", true)).collect(Collectors.joining(",", "(", ")")));
                    break;
                }
                default: {
                    if (this.values != null) {
                        throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ColumnDefinition.0", new String[]{Arrays.stream(this.values).collect(Collectors.joining(", ")), mysqlTypeName, this.name}));
                    }
                    if (this.decimals == null) break;
                    throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ColumnDefinition.1", new String[]{this.name}));
                }
            }
        }
        if (this.unsigned != null && this.unsigned.booleanValue()) {
            switch (this.type) {
                case DECIMAL: 
                case DOUBLE: 
                case FLOAT: 
                case TINYINT: 
                case SMALLINT: 
                case MEDIUMINT: 
                case INT: 
                case BIGINT: {
                    sb.append(" UNSIGNED");
                    break;
                }
                default: {
                    throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ColumnDefinition.0", new String[]{"UNSIGNED", mysqlTypeName, this.name}));
                }
            }
        }
        if (this.binary != null && this.binary.booleanValue()) {
            if (this.type == Type.STRING) {
                sb.append(" BINARY");
            } else {
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ColumnDefinition.0", new String[]{"BINARY", mysqlTypeName, this.name}));
            }
        }
        if (this.charset != null && !this.charset.isEmpty()) {
            switch (this.type) {
                case STRING: 
                case ENUM: 
                case SET: {
                    sb.append(" CHARACTER SET ").append(this.charset);
                    break;
                }
                default: {
                    throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ColumnDefinition.0", new String[]{"CHARACTER SET", mysqlTypeName, this.name}));
                }
            }
        }
        if (this.collation != null && !this.collation.isEmpty()) {
            switch (this.type) {
                case STRING: 
                case ENUM: 
                case SET: {
                    sb.append(" COLLATE ").append(this.collation);
                    break;
                }
                default: {
                    throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ColumnDefinition.0", new String[]{"COLLATE", mysqlTypeName, this.name}));
                }
            }
        }
        return sb.toString();
    }
}

