/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.devapi;

import com.mysql.cj.api.x.BaseSession;
import com.mysql.cj.api.x.Collection;
import com.mysql.cj.api.x.CreateTableStatement;
import com.mysql.cj.api.x.DatabaseObject;
import com.mysql.cj.api.x.Schema;
import com.mysql.cj.api.x.Table;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.mysqlx.ExprUnparser;
import com.mysql.cj.mysqlx.MysqlxError;
import com.mysql.cj.mysqlx.devapi.CollectionImpl;
import com.mysql.cj.mysqlx.devapi.CreateTableStatementImpl;
import com.mysql.cj.mysqlx.devapi.DatabaseObjectDescription;
import com.mysql.cj.mysqlx.devapi.TableImpl;
import java.util.List;
import java.util.stream.Collectors;

public class SchemaImpl
implements Schema {
    private BaseSession session;
    private String name;

    SchemaImpl(BaseSession session, String name) {
        this.session = session;
        this.name = name;
    }

    @Override
    public BaseSession getSession() {
        return this.session;
    }

    @Override
    public Schema getSchema() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DatabaseObject.DbObjectStatus existsInDatabase() {
        if (this.session.getMysqlxSession().schemaExists(this.name)) {
            return DatabaseObject.DbObjectStatus.EXISTS;
        }
        return DatabaseObject.DbObjectStatus.NOT_EXISTS;
    }

    @Override
    public List<Collection> getCollections() {
        return this.session.getMysqlxSession().getObjectNamesOfType(this.name, DatabaseObject.DbObjectType.COLLECTION).stream().map(this::getCollection).collect(Collectors.toList());
    }

    @Override
    public List<Collection> getCollections(String pattern) {
        return this.session.getMysqlxSession().getObjectNamesOfType(this.name, DatabaseObject.DbObjectType.COLLECTION, pattern).stream().map(this::getCollection).collect(Collectors.toList());
    }

    @Override
    public List<Table> getTables() {
        return this.session.getMysqlxSession().listObjects(this.name).stream().filter(descr -> descr.getObjectType() == DatabaseObject.DbObjectType.TABLE || descr.getObjectType() == DatabaseObject.DbObjectType.VIEW).map(this::getTable).collect(Collectors.toList());
    }

    @Override
    public List<Table> getTables(String pattern) {
        return this.session.getMysqlxSession().listObjects(this.name, pattern).stream().filter(descr -> descr.getObjectType() == DatabaseObject.DbObjectType.TABLE || descr.getObjectType() == DatabaseObject.DbObjectType.VIEW).map(this::getTable).collect(Collectors.toList());
    }

    @Override
    public Collection getCollection(String collectionName) {
        return new CollectionImpl(this, collectionName);
    }

    @Override
    public Collection getCollection(String collectionName, boolean requireExists) {
        CollectionImpl coll = new CollectionImpl(this, collectionName);
        if (requireExists && coll.existsInDatabase() != DatabaseObject.DbObjectStatus.EXISTS) {
            throw new WrongArgumentException(coll.toString() + " doesn't exist");
        }
        return coll;
    }

    @Override
    public Table getCollectionAsTable(String collectionName) {
        return this.getTable(collectionName);
    }

    @Override
    public Table getTable(String tableName) {
        return new TableImpl(this, tableName);
    }

    Table getTable(DatabaseObjectDescription descr) {
        return new TableImpl(this, descr);
    }

    @Override
    public Table getTable(String tableName, boolean requireExists) {
        TableImpl table = new TableImpl(this, tableName);
        if (requireExists && table.existsInDatabase() != DatabaseObject.DbObjectStatus.EXISTS) {
            throw new WrongArgumentException(table.toString() + " doesn't exist");
        }
        return table;
    }

    @Override
    public Collection createCollection(String collectionName) {
        this.session.getMysqlxSession().createCollection(this.name, collectionName);
        return new CollectionImpl(this, collectionName);
    }

    @Override
    public Collection createCollection(String collectionName, boolean reuseExistingObject) {
        try {
            return this.createCollection(collectionName);
        }
        catch (MysqlxError ex) {
            if (ex.getErrorCode() == 1050) {
                return this.getCollection(collectionName);
            }
            throw ex;
        }
    }

    @Override
    public CreateTableStatement.CreateTableSplitStatement createTable(String tableName) {
        return new CreateTableStatementImpl(this, tableName);
    }

    @Override
    public CreateTableStatement.CreateTableSplitStatement createTable(String tableName, boolean reuseExistingObject) {
        return new CreateTableStatementImpl(this, tableName, reuseExistingObject);
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == SchemaImpl.class && ((SchemaImpl)other).session == this.session) {
            return this.name.equals(((SchemaImpl)other).name);
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Schema(");
        sb.append(ExprUnparser.quoteIdentifier(this.name));
        sb.append(")");
        return sb.toString();
    }
}

