/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.updater;

import de.deadlocker8.budgetmaster.logic.updater.VersionInformation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import logger.Logger;
import nativeWindows.NativeLauncher;
import tools.Localization;
import tools.OS;
import tools.PathUtils;

public class Updater {
    private VersionInformation latestVersion = new VersionInformation(0, "-", "-");
    private static final String LATEST_VERSION_INFO_URL = "https://raw.githubusercontent.com/deadlocker8/BudgetMaster/master/src/de/deadlocker8/budgetmaster/resources/languages/_de.properties";
    private static final String BUILD_FOLDER = "https://github.com/deadlocker8/BudgetMaster/raw/master/build/";

    private VersionInformation getLatestVersionInformationFromServer() throws IOException {
        URL webseite = new URL(LATEST_VERSION_INFO_URL);
        URLConnection connection = webseite.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        VersionInformation versionInfo = new VersionInformation();
        Properties properties = new Properties();
        properties.load(bufferedReader);
        versionInfo.setVersionCode(Integer.parseInt(properties.getProperty("version.code", "-1")));
        versionInfo.setVersionName(properties.getProperty("version.name"));
        versionInfo.setDate(properties.getProperty("version.date"));
        if (!versionInfo.isComplete()) {
            throw new IllegalArgumentException("VersionInformation not complete");
        }
        return versionInfo;
    }

    public boolean isUpdateAvailable(int currentVersionCode) throws IOException {
        this.latestVersion = this.getLatestVersionInformationFromServer();
        return currentVersionCode < this.latestVersion.getVersionCode();
    }

    public VersionInformation getLatestVersion() {
        return this.latestVersion;
    }

    private void downloadLatestUpdater(OS.OSType osType) throws IOException {
        String ending = "jar";
        if (osType == OS.OSType.Windows) {
            ending = "exe";
        }
        Path target = Paths.get(PathUtils.getOSindependentPath() + Localization.getString("folder") + "/Updater." + ending, new String[0]);
        this.download("https://github.com/deadlocker8/BudgetMaster/raw/master/build/Updater." + ending, target);
        Logger.debug("Successfully downloaded latest updater");
    }

    private File getCurrentExecutableName() {
        return new File(Updater.class.getProtectionDomain().getCodeSource().getLocation().getPath());
    }

    public void downloadLatestVersion() throws Exception {
        Path target;
        File currentExecutable = this.getCurrentExecutableName();
        String currentFileName = currentExecutable.getName();
        if (!currentFileName.contains(".")) {
            Logger.debug("Update procedure will be skipped because BudgetMaster is running from source");
            return;
        }
        PathUtils.checkFolder(new File(PathUtils.getOSindependentPath() + Localization.getString("folder")));
        this.downloadLatestUpdater(OS.getType());
        if (currentFileName.endsWith(".exe")) {
            target = Paths.get(PathUtils.getOSindependentPath() + Localization.getString("folder") + "/update_BudgetMaster.exe", new String[0]);
            this.download("https://github.com/deadlocker8/BudgetMaster/raw/master/build/BudgetMaster.exe", target);
            Logger.debug("Successfully downloaded latest EXE");
        } else {
            target = Paths.get(PathUtils.getOSindependentPath() + Localization.getString("folder") + "/update_BudgetMasterClient.jar", new String[0]);
            this.download("https://github.com/deadlocker8/BudgetMaster/raw/master/build/BudgetMasterClient.jar", target);
            Logger.debug("Successfully downloaded latest JAR");
        }
        String params = target.toString().replace(" ", "%20") + " " + currentExecutable.getAbsolutePath().replace(" ", "%20") + " " + Localization.getString("app.name");
        Logger.debug(params);
        if (OS.getType() == OS.OSType.Windows) {
            NativeLauncher.executeAsAdministrator(Paths.get(PathUtils.getOSindependentPath() + Localization.getString("folder") + "/Updater.exe", new String[0]).toString(), params);
        } else {
            ProcessBuilder pb = new ProcessBuilder("java", "-jar", Paths.get(PathUtils.getOSindependentPath() + Localization.getString("folder") + "/Updater.jar", new String[0]).toString(), target.toString().replace(" ", "%20"), currentExecutable.toString().replace(" ", "%20"), Localization.getString("app.name"));
            pb.start();
        }
        System.exit(0);
    }

    public void download(String url, Path target) throws IOException {
        URL website = new URL(url);
        InputStream in = website.openStream();
        Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
    }
}

