/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.tag.match;

import com.google.gson.Gson;
import de.deadlocker8.budgetmaster.logic.tag.Tag;
import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.taghandler.DatabaseTagHandler;
import java.util.ArrayList;
import spark.Request;
import spark.Response;
import spark.Spark;

public class TagMatchGetAllForPayment
implements AdvancedRoute {
    private DatabaseTagHandler tagHandler;
    private Gson gson;

    public TagMatchGetAllForPayment(DatabaseTagHandler tagHandler, Gson gson) {
        this.tagHandler = tagHandler;
        this.gson = gson;
    }

    @Override
    public void before() {
        this.tagHandler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        if (!req.queryParams().contains("paymentID")) {
            Spark.halt(400, "Bad Request");
        }
        try {
            int paymentID = Integer.parseInt(req.queryMap("paymentID").value());
            if (paymentID < 0) {
                Spark.halt(400, "Bad Request");
            }
            ArrayList<Integer> tagIDs = this.tagHandler.getAllTagsForPayment(paymentID);
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (Integer currentTagID : tagIDs) {
                Tag currentTag = this.tagHandler.getTagByID(currentTagID);
                if (currentTag == null) continue;
                tags.add(currentTag);
            }
            return this.gson.toJson(tags);
        }
        catch (IllegalStateException ex) {
            Spark.halt(500, "Internal Server Error");
        }
        catch (Exception e) {
            Spark.halt(400, "Bad Request");
        }
        return null;
    }

    @Override
    public void after() {
        this.tagHandler.closeConnection();
    }
}

