/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.tag.tag;

import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.taghandler.DatabaseTagHandler;
import spark.Request;
import spark.Response;
import spark.Spark;

public class TagDelete
implements AdvancedRoute {
    private DatabaseTagHandler tagHandler;

    public TagDelete(DatabaseTagHandler tagHandler) {
        this.tagHandler = tagHandler;
    }

    @Override
    public void before() {
        this.tagHandler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        if (!req.queryParams().contains("id")) {
            Spark.halt(400, "Bad Request");
        }
        int id = -1;
        try {
            id = Integer.parseInt(req.queryMap("id").value());
            if (id < 0) {
                Spark.halt(400, "Bad Request");
            }
            try {
                this.tagHandler.deleteTag(id);
                return "";
            }
            catch (IllegalStateException ex) {
                Spark.halt(500, "Internal Server Error");
            }
        }
        catch (Exception e) {
            Spark.halt(400, "Bad Request");
        }
        return "";
    }

    @Override
    public void after() {
        this.tagHandler.closeConnection();
    }
}

