/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.main;

import de.deadlocker8.budgetmaster.logic.Settings;
import de.deadlocker8.budgetmaster.logic.utils.FileHelper;
import de.deadlocker8.budgetmasterclient.ui.ShutdownHandler;
import de.deadlocker8.budgetmasterclient.ui.controller.SplashScreenController;
import java.io.File;
import java.util.Locale;
import javafx.application.Application;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import logger.FileOutputMode;
import logger.Logger;
import tools.Localization;
import tools.PathUtils;

public class Main
extends Application {
    public static Stage primaryStage;

    public void start(Stage stage) {
        primaryStage = stage;
        Settings settings = FileHelper.loadSettings();
        if (settings != null && settings.getLanguage() != null) {
            Localization.loadLanguage(settings.getLanguage().getLocale());
        }
        ShutdownHandler shutdownHandler = new ShutdownHandler();
        Image icon = new Image("/de/deadlocker8/budgetmaster/icon.png");
        new SplashScreenController(stage, icon, this.getParameters().getNamed().get("update") != null, shutdownHandler);
    }

    public void init() throws Exception {
        Localization.init("de/deadlocker8/budgetmaster/languages/");
        Localization.loadLanguage(Locale.ENGLISH);
        Application.Parameters params = this.getParameters();
        String logLevelParam = (String)params.getNamed().get("loglevel");
        Logger.setLevel(logLevelParam);
        File logFolder = new File(PathUtils.getOSindependentPath() + Localization.getString("folder"));
        PathUtils.checkFolder(logFolder);
        Logger.enableFileOutput(logFolder, System.out, System.err, FileOutputMode.COMBINED);
        Logger.appInfo(Localization.getString("app.name"), Localization.getString("version.name"), Localization.getString("version.code"), Localization.getString("version.date"));
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }
}

