/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.cells;

import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmaster.logic.category.CategoryBudget;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import de.deadlocker8.budgetmasterclient.ui.controller.HomeController;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import tools.ConvertTo;

public class CategoryBudgetCell
extends ListCell<CategoryBudget> {
    private final double HEIGHT = 40.0;
    private HomeController homeController;

    public CategoryBudgetCell(HomeController homeController) {
        this.homeController = homeController;
    }

    protected void updateItem(CategoryBudget item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!empty) {
            HBox hbox = new HBox();
            Category currentCategory = item.getCategory();
            Label labelCircle = new Label(currentCategory.getName().substring(0, 1).toUpperCase());
            labelCircle.setPrefWidth(40.0);
            labelCircle.setPrefHeight(40.0);
            labelCircle.setAlignment(Pos.CENTER);
            labelCircle.getStyleClass().add((Object)"greylabel");
            String textColor = ConvertTo.toRGBHex(ConvertTo.getAppropriateTextColor(Color.web((String)currentCategory.getColor())));
            labelCircle.setStyle("-fx-background-color: " + currentCategory.getColor() + "; -fx-background-radius: 50%; -fx-text-fill: " + textColor + "; -fx-font-weight: bold; -fx-font-size: 20;");
            hbox.getChildren().add((Object)labelCircle);
            Label labelName = new Label(currentCategory.getName());
            labelName.setPrefHeight(40.0);
            labelName.setStyle("-fx-font-weight: bold; -fx-font-size: 16; -fx-text-fill: #212121");
            labelName.setAlignment(Pos.CENTER);
            labelName.getStyleClass().add((Object)"greylabel");
            hbox.getChildren().add((Object)labelName);
            HBox.setMargin((Node)labelName, (Insets)new Insets(0.0, 0.0, 0.0, 20.0));
            Region r = new Region();
            hbox.getChildren().add((Object)r);
            HBox.setHgrow((Node)r, (Priority)Priority.ALWAYS);
            Label labelBudget = new Label(Helpers.getCurrencyString(item.getBudget() / 100.0, this.homeController.getController().getSettings().getCurrency()));
            labelBudget.setStyle("-fx-font-weight: bold; -fx-font-size: 16; -fx-text-fill: #247A2D;");
            if (item.getBudget() > 0.0) {
                labelBudget.setText("+" + labelBudget.getText());
            } else {
                labelBudget.setStyle("-fx-font-weight: bold; -fx-font-size: 16; -fx-text-fill: #CC0000");
            }
            labelBudget.setPrefHeight(40.0);
            labelBudget.setAlignment(Pos.CENTER);
            labelBudget.getStyleClass().add((Object)"greylabel");
            hbox.getChildren().add((Object)labelBudget);
            HBox.setMargin((Node)labelBudget, (Insets)new Insets(0.0, 0.0, 0.0, 20.0));
            hbox.setPadding(new Insets(10.0));
            this.setStyle("-fx-background: transparent; -fx-border-color: #545454; -fx-border-width: 0 0 1 0");
            this.setGraphic((Node)hbox);
            this.setAlignment(Pos.CENTER);
        } else {
            this.setStyle("-fx-background: transparent");
            this.setText(null);
            this.setGraphic(null);
        }
    }
}

