/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.commandLine.commands;

import de.deadlocker8.budgetmaster.logic.utils.FileHelper;
import de.deadlocker8.budgetmaster.logic.utils.LanguageType;
import de.deadlocker8.budgetmasterclient.ui.RestartHandler;
import de.deadlocker8.budgetmasterclient.ui.commandLine.CommandBundle;
import de.deadlocker8.budgetmasterclient.ui.commandLine.commands.Command;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import tools.Localization;
import tools.PathUtils;

public class CommandSwitch
extends Command {
    public CommandSwitch() {
        this.keyword = "switch";
        this.numberOfParams = 0;
        this.helptText = "help.switch";
    }

    @Override
    public void execute(String[] command, CommandBundle bundle) {
        if (!this.isValid(command)) {
            bundle.getController().print(bundle.getString("error.invalid.arguments"));
            return;
        }
        Path currentSettingsFile = Paths.get(PathUtils.getOSindependentPath() + Localization.getString("folder") + "/settings.json", new String[0]);
        Path secondSettingsFile = Paths.get(PathUtils.getOSindependentPath() + Localization.getString("folder") + "/_settings.json", new String[0]);
        if (secondSettingsFile.toFile().exists()) {
            try {
                Path temp = Paths.get(PathUtils.getOSindependentPath() + Localization.getString("folder") + "/__settings.json", new String[0]);
                Files.move(currentSettingsFile, temp, new CopyOption[0]);
                Files.move(secondSettingsFile, currentSettingsFile, new CopyOption[0]);
                Files.move(temp, secondSettingsFile, new CopyOption[0]);
            }
            catch (IOException e) {
                bundle.getController().print(bundle.getString("switch.error"));
            }
        } else {
            bundle.getController().print(bundle.getString("switch.new"));
            try {
                Files.copy(currentSettingsFile, secondSettingsFile, new CopyOption[0]);
            }
            catch (IOException e) {
                bundle.getController().print(bundle.getString("switch.error"));
            }
        }
        LanguageType previousLanguage = bundle.getParentController().getSettings().getLanguage();
        bundle.getParentController().setSettings(FileHelper.loadSettings());
        bundle.getParentController().getSettingsController().prefill();
        RestartHandler restartHandler = new RestartHandler(bundle.getParentController());
        restartHandler.handleRestart(previousLanguage);
        bundle.getController().print(bundle.getString("switch.success"));
    }
}

