/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmaster.logic.serverconnection.ExceptionHandler;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnection;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmasterclient.ui.Refreshable;
import de.deadlocker8.budgetmasterclient.ui.Styleable;
import de.deadlocker8.budgetmasterclient.ui.cells.CategoryCell;
import de.deadlocker8.budgetmasterclient.ui.controller.BaseController;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import de.deadlocker8.budgetmasterclient.ui.controller.NewCategoryController;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import logger.Logger;
import tools.ConvertTo;
import tools.Localization;

public class CategoryController
extends BaseController
implements Refreshable,
Styleable {
    @FXML
    private AnchorPane anchorPaneMain;
    @FXML
    private Button buttonCategory;
    @FXML
    private ListView<Category> listView;
    private Controller controller;

    public void init(Controller controller) {
        this.controller = controller;
        CategoryController thisController = this;
        this.listView.setCellFactory(param -> {
            CategoryCell cell = new CategoryCell(thisController);
            cell.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
                if (event.getClickCount() == 2 && ((Category)cell.getItem()).getID() != 1) {
                    this.newCategory(true, (Category)cell.getItem());
                }
            });
            return cell;
        });
        this.listView.getSelectionModel().selectedIndexProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.listView.getSelectionModel().select(-1)));
        Label labelPlaceholder = new Label(Localization.getString("categories.placeholder"));
        labelPlaceholder.setStyle("-fx-font-size: 16");
        this.listView.setPlaceholder((Node)labelPlaceholder);
        this.applyStyle();
        this.refreshListView();
    }

    public void refreshListView() {
        ArrayList<Category> categories;
        this.listView.getItems().clear();
        if (this.controller.getCategoryHandler() != null && (categories = this.controller.getCategoryHandler().getCategoriesWithoutNone()) != null && categories.size() > 0) {
            this.listView.getItems().setAll(categories);
        }
    }

    public void createNewCategory() {
        this.newCategory(false, null);
    }

    public void newCategory(boolean edit, Category category) {
        new NewCategoryController(this.controller.getStage(), this.controller, this, edit, category);
    }

    public void deleteCategory(int ID) {
        try {
            ServerConnection connection = new ServerConnection(this.controller.getSettings());
            connection.deleteCategory(ID);
            this.controller.refresh(this.controller.getFilterSettings());
        }
        catch (Exception e) {
            Logger.error(e);
            this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
        }
    }

    public Controller getController() {
        return this.controller;
    }

    @Override
    public void refresh() {
        this.refreshListView();
    }

    @Override
    public void applyStyle() {
        this.buttonCategory.setGraphic((Node)new FontIcon(FontIconType.PLUS, 18, Color.WHITE));
        this.anchorPaneMain.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND));
        this.buttonCategory.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 16;");
    }
}

