/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmaster.logic.charts.CategoriesChart;
import de.deadlocker8.budgetmaster.logic.charts.CategoryInOutSum;
import de.deadlocker8.budgetmaster.logic.charts.ChartExportable;
import de.deadlocker8.budgetmaster.logic.charts.LegendType;
import de.deadlocker8.budgetmaster.logic.charts.MonthBarChart;
import de.deadlocker8.budgetmaster.logic.charts.MonthInOutSum;
import de.deadlocker8.budgetmaster.logic.charts.MonthLineChart;
import de.deadlocker8.budgetmaster.logic.serverconnection.ExceptionHandler;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnection;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import de.deadlocker8.budgetmasterclient.ui.Refreshable;
import de.deadlocker8.budgetmasterclient.ui.Styleable;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import de.deadlocker8.budgetmasterclient.ui.controller.ExportChartController;
import de.deadlocker8.budgetmasterclient.utils.LoadingModal;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import logger.Logger;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import tools.AlertGenerator;
import tools.ConvertTo;
import tools.Localization;
import tools.Worker;

public class ChartController
implements Refreshable,
Styleable {
    @FXML
    private AnchorPane anchorPaneMain;
    @FXML
    private Accordion accordion;
    @FXML
    private DatePicker datePickerStart;
    @FXML
    private VBox vboxChartCategories;
    @FXML
    private DatePicker datePickerEnd;
    @FXML
    private VBox vboxChartMonth;
    @FXML
    private Button buttonChartCategoriesShow;
    @FXML
    private Button buttonChartCategoriesExport;
    @FXML
    private ComboBox<String> comboBoxStartMonth;
    @FXML
    private ComboBox<String> comboBoxStartYear;
    @FXML
    private ComboBox<String> comboBoxEndMonth;
    @FXML
    private ComboBox<String> comboBoxEndYear;
    @FXML
    private Button buttonChartMonthShow;
    @FXML
    private Button buttonChartMonthExport;
    @FXML
    private RadioButton radioButtonBars;
    @FXML
    private RadioButton radioButtonLines;
    private Controller controller;
    private File lastExportPath;
    private CategoriesChart categoriesChart;
    private MonthLineChart monthLineChart;
    private MonthBarChart monthBarChart;

    public void init(Controller controller) {
        this.controller = controller;
        this.datePickerEnd.setDayCellFactory(param -> new DateCell(){

            public void updateItem(LocalDate item, boolean empty) {
                super.updateItem(item, empty);
                if (item.isBefore(((LocalDate)ChartController.this.datePickerStart.getValue()).plusDays(1L))) {
                    this.setDisable(true);
                    this.setStyle("-fx-background-color: #ffc0cb;");
                }
            }
        });
        this.comboBoxStartMonth.setItems(FXCollections.observableArrayList(Helpers.getMonthList()));
        this.comboBoxStartYear.setItems(FXCollections.observableArrayList(Helpers.getYearList()));
        this.comboBoxEndMonth.setItems(FXCollections.observableArrayList(Helpers.getMonthList()));
        this.comboBoxEndYear.setItems(FXCollections.observableArrayList(Helpers.getYearList()));
        ToggleGroup toggleGroup = new ToggleGroup();
        this.radioButtonBars.setToggleGroup(toggleGroup);
        this.radioButtonBars.setSelected(true);
        this.radioButtonLines.setToggleGroup(toggleGroup);
        this.accordion.setExpandedPane((TitledPane)this.accordion.getPanes().get(0));
        this.vboxChartMonth.setSpacing(15.0);
        this.applyStyle();
    }

    public void buttonChartCategoriesShow() {
        this.chartCategoriesShow(LegendType.NORMAL);
    }

    public void chartCategoriesShow(LegendType legendType) {
        DateTime startDate = DateTime.parse(((LocalDate)this.datePickerStart.getValue()).toString());
        DateTime endDate = DateTime.parse(((LocalDate)this.datePickerEnd.getValue()).toString());
        try {
            ServerConnection connection = new ServerConnection(this.controller.getSettings());
            ArrayList<CategoryInOutSum> sums = connection.getCategoryInOutSumForMonth(startDate, endDate);
            Platform.runLater(() -> {
                this.vboxChartCategories.getChildren().clear();
                this.categoriesChart = new CategoriesChart(Localization.getString("chart.categories.title.incomes"), Localization.getString("chart.categories.title.payments"), sums, this.controller.getSettings().getCurrency(), legendType);
                this.vboxChartCategories.getChildren().add((Object)this.categoriesChart);
                VBox.setVgrow((Node)this.categoriesChart, (Priority)Priority.ALWAYS);
            });
        }
        catch (Exception e) {
            Logger.error(e);
            Platform.runLater(() -> this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e)));
        }
    }

    public void chartCategoriesExport() {
        if (this.categoriesChart != null) {
            this.export(this.categoriesChart);
        }
    }

    public void chartMonthExport() {
        if (this.radioButtonLines.isSelected()) {
            if (this.monthLineChart != null) {
                this.export(this.monthLineChart);
            }
        } else if (this.monthBarChart != null) {
            this.export(this.monthBarChart);
        }
    }

    public void export(ChartExportable chart) {
        Worker.runLater(() -> Platform.runLater(() -> new ExportChartController(this.controller.getStage(), this, chart)));
    }

    public void chartMonthShow() {
        Platform.runLater(() -> this.vboxChartMonth.getChildren().clear());
        String startMonth = (String)this.comboBoxStartMonth.getValue();
        String startYear = (String)this.comboBoxStartYear.getValue();
        String endMonth = (String)this.comboBoxEndMonth.getValue();
        String endYear = (String)this.comboBoxEndYear.getValue();
        String startDateString = "01-" + startMonth + "-" + startYear;
        DateTime startDate = DateTime.parse(startDateString, DateTimeFormat.forPattern("dd-MMMM-YYYY").withLocale(this.controller.getSettings().getLanguage().getLocale()));
        String endDateString = "01-" + endMonth + "-" + endYear;
        DateTime endDate = DateTime.parse(endDateString, DateTimeFormat.forPattern("dd-MMMM-YYYY").withLocale(this.controller.getSettings().getLanguage().getLocale()));
        if (endDate.isBefore(startDate)) {
            Platform.runLater(() -> AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.enddate.before.startdate"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false));
            return;
        }
        try {
            ServerConnection connection = new ServerConnection(this.controller.getSettings());
            ArrayList<MonthInOutSum> sums = connection.getMonthInOutSum(startDate, endDate);
            Platform.runLater(() -> {
                this.vboxChartMonth.getChildren().clear();
                if (this.radioButtonBars.isSelected()) {
                    this.monthBarChart = new MonthBarChart(sums, this.controller.getSettings().getCurrency());
                    this.vboxChartMonth.getChildren().add((Object)this.monthBarChart);
                    VBox.setVgrow((Node)this.monthBarChart, (Priority)Priority.ALWAYS);
                } else {
                    this.monthLineChart = new MonthLineChart(sums, this.controller.getSettings().getCurrency());
                    this.vboxChartMonth.getChildren().add((Object)this.monthLineChart);
                    VBox.setVgrow((Node)this.monthLineChart, (Priority)Priority.ALWAYS);
                }
            });
        }
        catch (Exception e) {
            Logger.error(e);
            Platform.runLater(() -> this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e)));
        }
    }

    public Controller getController() {
        return this.controller;
    }

    public void setLastExportPath(File lastExportPath) {
        this.lastExportPath = lastExportPath;
    }

    public File getLastExportPath() {
        return this.lastExportPath;
    }

    @Override
    public void refresh() {
        LoadingModal.showModal(this.controller, Localization.getString("title.modal"), Localization.getString("load.charts"), this.controller.getStage(), this.controller.getIcon());
        LocalDate startDate = LocalDate.parse(this.controller.getCurrentDate().withDayOfMonth(1).toString("yyyy-MM-dd"));
        LocalDate endDate = LocalDate.parse(this.controller.getCurrentDate().dayOfMonth().withMaximumValue().toString("yyyy-MM-dd"));
        this.datePickerStart.setValue((Object)startDate);
        this.datePickerEnd.setValue((Object)endDate);
        this.comboBoxStartMonth.setValue((Object)this.controller.getCurrentDate().minusMonths(5).monthOfYear().getAsText(this.controller.getSettings().getLanguage().getLocale()));
        this.comboBoxStartYear.setValue((Object)String.valueOf(this.controller.getCurrentDate().minusMonths(5).getYear()));
        this.comboBoxEndMonth.setValue((Object)this.controller.getCurrentDate().plusMonths(6).monthOfYear().getAsText(this.controller.getSettings().getLanguage().getLocale()));
        this.comboBoxEndYear.setValue((Object)String.valueOf(this.controller.getCurrentDate().plusMonths(6).getYear()));
        Worker.runLater(() -> {
            this.chartCategoriesShow(LegendType.NORMAL);
            this.chartMonthShow();
            Platform.runLater(() -> LoadingModal.closeModal());
        });
    }

    @Override
    public void applyStyle() {
        this.anchorPaneMain.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND));
        this.vboxChartCategories.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND));
        this.vboxChartCategories.setSpacing(20.0);
        this.vboxChartMonth.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND));
        this.buttonChartCategoriesShow.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE));
        this.buttonChartCategoriesShow.setGraphic((Node)new FontIcon(FontIconType.CHECK, 16, Color.WHITE));
        this.buttonChartCategoriesExport.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE));
        this.buttonChartCategoriesExport.setGraphic((Node)new FontIcon(FontIconType.SAVE, 16, Color.WHITE));
        this.buttonChartMonthShow.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE));
        this.buttonChartMonthShow.setGraphic((Node)new FontIcon(FontIconType.CHECK, 16, Color.WHITE));
        this.buttonChartMonthExport.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE));
        this.buttonChartMonthExport.setGraphic((Node)new FontIcon(FontIconType.SAVE, 16, Color.WHITE));
    }
}

