/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmaster.logic.Settings;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.FileHelper;
import de.deadlocker8.budgetmasterclient.ui.ShutdownHandler;
import de.deadlocker8.budgetmasterclient.ui.Styleable;
import de.deadlocker8.budgetmasterclient.ui.controller.BaseController;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import de.deadlocker8.budgetmasterclient.ui.customAlert.CustomAlertController;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.io.IOException;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.Window;
import logger.Logger;
import tools.AlertGenerator;
import tools.ConvertTo;
import tools.HashUtils;
import tools.Localization;

public class SplashScreenController
extends BaseController
implements Styleable {
    @FXML
    private ImageView imageViewLogo;
    @FXML
    private Label labelVersion;
    @FXML
    private PasswordField textFieldPassword;
    @FXML
    private Button buttonLogin;
    private Stage parentStage;
    private Image icon;
    private Settings settings;
    private boolean isFirstStart;
    private boolean isStartingAfterUpdate;
    private ShutdownHandler shutdownHandler;

    public SplashScreenController(Stage parentStage, Image icon, boolean isStartingAfterUpdate, ShutdownHandler shutdownHandler) {
        this.parentStage = parentStage;
        this.icon = icon;
        this.isStartingAfterUpdate = isStartingAfterUpdate;
        this.shutdownHandler = shutdownHandler;
        this.load("/de/deadlocker8/budgetmaster/ui/fxml/SplashScreen.fxml", Localization.getBundle());
        this.getStage().show();
    }

    @Override
    public void initStage(Stage stage) {
        stage.initOwner((Window)this.parentStage);
        stage.setWidth(450.0);
        stage.setHeight(250.0);
        stage.setResizable(false);
        stage.getIcons().add((Object)this.icon);
        stage.setTitle(Localization.getString("app.name"));
    }

    @Override
    public void init() {
        this.imageViewLogo.setImage(this.icon);
        this.labelVersion.setText("v" + Localization.getString("version.name"));
        this.applyStyle();
        this.textFieldPassword.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                event.consume();
                this.login();
            }
        });
        if (this.isStartingAfterUpdate) {
            Platform.runLater(() -> AlertGenerator.showAlert(Alert.AlertType.INFORMATION, Localization.getString("info.title.start.after.update"), Localization.getString("info.header.text.start.after.update", Localization.getString("version.name")), Localization.getString("info.text.start.after.update"), this.icon, (Window)this.getStage(), null, false));
        }
        this.settings = FileHelper.loadSettings();
        if (this.settings == null) {
            this.settings = new Settings();
            Platform.runLater(() -> AlertGenerator.showAlert(Alert.AlertType.INFORMATION, Localization.getString("info.title.welcome"), Localization.getString("info.header.text.welcome"), Localization.getString("info.text.welcome.first.start"), this.icon, (Window)this.getStage(), null, false));
            this.isFirstStart = true;
        } else if (this.settings.getClientSecret() == null) {
            Platform.runLater(() -> AlertGenerator.showAlert(Alert.AlertType.INFORMATION, Localization.getString("info.title.welcome"), Localization.getString("info.header.text.welcome"), Localization.getString("info.text.welcome.compatibility"), this.icon, (Window)this.getStage(), null, false));
            this.isFirstStart = true;
        } else {
            this.isFirstStart = false;
        }
    }

    public void login() {
        String password = this.textFieldPassword.getText().trim();
        if (password == null || password.isEmpty()) {
            new CustomAlertController(this.getStage(), this, Alert.AlertType.WARNING, Localization.getString("title.warning"), Localization.getString("warning.empty.password"));
            return;
        }
        if (this.isFirstStart) {
            this.settings.setClientSecret(HashUtils.hash(password, "ny9/Y+G|WrJ,82|oIYQQ X %i-sq#4,uA-qKPtwFPnw+s(k2`rV)^-a1|t{D3Z>S"));
            try {
                FileHelper.saveSettings(this.settings);
                this.getStage().close();
                this.openBudgetMaster();
            }
            catch (IOException e) {
                Logger.error(e);
                new CustomAlertController(this.getStage(), this, Alert.AlertType.WARNING, Localization.getString("title.error"), Localization.getString("error.password.save"));
                return;
            }
        } else {
            if (!HashUtils.hash(password, "ny9/Y+G|WrJ,82|oIYQQ X %i-sq#4,uA-qKPtwFPnw+s(k2`rV)^-a1|t{D3Z>S").equals(this.settings.getClientSecret())) {
                new CustomAlertController(this.getStage(), this, Alert.AlertType.WARNING, Localization.getString("title.warning"), Localization.getString("warning.wrong.password"));
                return;
            }
            this.getStage().close();
            this.openBudgetMaster();
        }
    }

    private void openBudgetMaster() {
        new Controller(this.settings, this.shutdownHandler);
    }

    public Image getIcon() {
        return this.icon;
    }

    @Override
    public void applyStyle() {
        this.buttonLogin.setGraphic((Node)new FontIcon(FontIconType.SIGN_IN, 18, Color.WHITE));
        this.buttonLogin.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 16;");
        this.buttonLogin.setPadding(new Insets(3.0, 7.0, 3.0, 7.0));
    }
}

