/*
 * Decompiled with CFR 0.152.
 */
package serializer;

import java.util.ArrayList;

public class Header {
    private int versionCode;
    private ArrayList<String> elements;
    private ArrayList<Integer> headerParts;

    public Header(int versionCode) {
        this.versionCode = versionCode;
        this.elements = new ArrayList();
    }

    public Header(String data) {
        this.headerParts = new ArrayList();
        this.versionCode = Integer.parseInt(data.substring(0, 2));
        int numberOfElements = Integer.parseInt(data.substring(2, 6));
        int i = 0;
        while (i < numberOfElements) {
            this.headerParts.add(Integer.parseInt(data.substring(6 + i * 4, 6 + i * 4 + 4)));
            ++i;
        }
    }

    public void addElement(String newElement) {
        this.elements.add(newElement);
    }

    public int getHeaderSize() {
        return 6 + this.headerParts.size() * 4;
    }

    public int getNumberOfElements() {
        return this.headerParts.size();
    }

    public int getHeaderPart(int position) {
        return this.headerParts.get(position);
    }

    public String createHeader() {
        String header = String.valueOf(String.format("%02d", this.versionCode)) + String.format("%04d", this.elements.size());
        for (String current : this.elements) {
            header = String.valueOf(header) + String.format("%04d", current.length());
        }
        return header;
    }
}

