/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.net.InetAddress;
import java.net.NetworkInterface;

public class MACAddress {
    private String macAddress;

    public MACAddress() {
        try {
            this.macAddress = this.getMacAddressFromSystem();
        }
        catch (Exception e) {
            this.macAddress = "0";
        }
    }

    private String getMacAddressFromSystem() throws Exception {
        InetAddress ip = InetAddress.getLocalHost();
        NetworkInterface network = NetworkInterface.getByInetAddress(ip);
        byte[] mac = network.getHardwareAddress();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < mac.length) {
            sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            ++i;
        }
        return sb.toString();
    }

    public String getMacAddress() {
        return this.macAddress;
    }
}

