/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.utils;

import com.google.gson.Gson;
import de.deadlocker8.budgetmaster.logic.Settings;
import de.deadlocker8.budgetmaster.logic.database.Database;
import de.deadlocker8.budgetmaster.logic.database.OldDatabase;
import de.deadlocker8.budgetmaster.logic.tag.Tag;
import de.deadlocker8.budgetmaster.logic.tag.TagMatch;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import tools.Localization;
import tools.PathUtils;

public class FileHelper {
    public static Settings loadSettings() {
        try {
            Gson gson = new Gson();
            BufferedReader reader = Files.newBufferedReader(Paths.get(PathUtils.getOSindependentPath() + Localization.getString("folder") + "/settings.json", new String[0]), Charset.forName("UTF-8"));
            Settings settings = gson.fromJson((Reader)reader, Settings.class);
            ((Reader)reader).close();
            return settings;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void saveSettings(Settings settings) throws IOException {
        Gson gson = new Gson();
        String jsonString = gson.toJson(settings);
        PathUtils.checkFolder(new File(PathUtils.getOSindependentPath() + Localization.getString("folder")));
        BufferedWriter writer = Files.newBufferedWriter(Paths.get(PathUtils.getOSindependentPath() + Localization.getString("folder") + "/settings.json", new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        writer.write(jsonString);
        ((Writer)writer).close();
    }

    public static Database loadDatabaseJSON(File file) throws IOException {
        String line;
        Gson gson = new Gson();
        BufferedReader reader = Files.newBufferedReader(Paths.get(file.getAbsolutePath(), new String[0]), Charset.forName("UTF-8"));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
        reader.close();
        String jsonString = sb.toString();
        if (jsonString.contains("BUDGETMASTER_DATABASE") && jsonString.contains("VERSION")) {
            Database database;
            int start = jsonString.indexOf("\"VERSION\": ");
            int version = Integer.parseInt(jsonString.substring(start += 11, start + 1));
            switch (version) {
                case 2: {
                    database = gson.fromJson(jsonString, Database.class);
                    break;
                }
                default: {
                    return FileHelper.loadOldDatabase(gson, jsonString);
                }
            }
            return database;
        }
        return FileHelper.loadOldDatabase(gson, jsonString);
    }

    private static Database loadOldDatabase(Gson gson, String jsonString) throws IOException {
        OldDatabase olDatabase = gson.fromJson(jsonString, OldDatabase.class);
        return new Database(olDatabase.getCategories(), olDatabase.getNormalPayments(), olDatabase.getRepeatingPayments(), new ArrayList<Tag>(), new ArrayList<TagMatch>());
    }

    public static void saveDatabaseJSON(File file, String databaseJSON) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(Paths.get(file.getAbsolutePath(), new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        writer.write(databaseJSON);
        ((Writer)writer).close();
    }
}

