/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.logic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.deadlocker8.budgetmasterserver.logic.Settings;
import de.deadlocker8.budgetmasterserver.logic.database.creator.DatabaseCreator;
import de.deadlocker8.budgetmasterserver.logic.database.creator.MysqlDatabaseCreator;
import de.deadlocker8.budgetmasterserver.logic.database.creator.SqliteDatabaseCreator;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import de.deadlocker8.budgetmasterserver.logic.database.handler.MysqlDatabaseHandler;
import de.deadlocker8.budgetmasterserver.logic.database.handler.SqliteDatabaseHandler;
import de.deadlocker8.budgetmasterserver.logic.database.taghandler.DatabaseTagHandler;
import de.deadlocker8.budgetmasterserver.logic.database.taghandler.MysqlDatabaseTagHandler;
import de.deadlocker8.budgetmasterserver.logic.database.taghandler.SqliteDatabaseTagHandler;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class Utils {
    public static Settings loadSettings() throws IOException, URISyntaxException {
        Gson gson = new Gson();
        String settingsJSON = new String(Files.readAllBytes(Paths.get(Settings.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent().resolve("settings.json")));
        Settings settings = gson.fromJson(settingsJSON, Settings.class);
        return settings;
    }

    public static void saveSettings(Settings settings) throws IOException, URISyntaxException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonString = gson.toJson(settings);
        BufferedWriter writer = Files.newBufferedWriter(Paths.get(Settings.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent().resolve("settings.json"), new OpenOption[0]);
        writer.write(jsonString);
        ((Writer)writer).close();
    }

    public static Connection getDatabaseConnection(Settings settings) throws SQLException, ClassNotFoundException {
        Class.forName("org.sqlite.JDBC");
        if (settings.getDatabaseType().equals("mysql")) {
            return DriverManager.getConnection("jdbc:mysql://" + settings.getDatabaseUrl() + settings.getDatabaseName() + "?useLegacyDatetimeCode=false&serverTimezone=Europe/Berlin&autoReconnect=true&wait_timeout=86400", settings.getDatabaseUsername(), settings.getDatabasePassword());
        }
        return DriverManager.getConnection("jdbc:sqlite://" + settings.getDatabaseUrl());
    }

    public static DatabaseCreator getDatabaseCreator(Connection connection, Settings settings) {
        if (settings.getDatabaseType().equals("mysql")) {
            return new MysqlDatabaseCreator(connection, settings);
        }
        return new SqliteDatabaseCreator(connection, settings);
    }

    public static DatabaseHandler getDatabaseHandler(Settings settings) throws ClassNotFoundException {
        Class.forName("org.sqlite.JDBC");
        if (settings.getDatabaseType().equals("mysql")) {
            return new MysqlDatabaseHandler(settings);
        }
        return new SqliteDatabaseHandler(settings);
    }

    public static DatabaseTagHandler getDatabaseTagHandler(Settings settings) throws ClassNotFoundException {
        Class.forName("org.sqlite.JDBC");
        if (settings.getDatabaseType().equals("mysql")) {
            return new MysqlDatabaseTagHandler(settings);
        }
        return new SqliteDatabaseTagHandler(settings);
    }
}

