/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.logic.database;

import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmaster.logic.database.Database;
import de.deadlocker8.budgetmaster.logic.payment.NormalPayment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPayment;
import de.deadlocker8.budgetmaster.logic.tag.Tag;
import de.deadlocker8.budgetmaster.logic.tag.TagMatch;
import de.deadlocker8.budgetmasterserver.logic.Settings;
import de.deadlocker8.budgetmasterserver.logic.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import logger.Logger;

public class DatabaseExporter {
    private Connection connection;

    public DatabaseExporter(Settings settings) throws IllegalStateException {
        try {
            this.connection = Utils.getDatabaseConnection(settings);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new IllegalStateException("Cannot connect the database!", e);
        }
    }

    public Database exportDatabase() {
        ArrayList<Category> categories = this.getAllCategories();
        ArrayList<NormalPayment> normalPayments = this.getAllNormalPayments();
        ArrayList<RepeatingPayment> repeatingPayments = this.getAllRepeatingPayments();
        ArrayList<Tag> tags = this.getAllTags();
        ArrayList<TagMatch> tagMatches = this.getAllTagMatches();
        return new Database(categories, normalPayments, repeatingPayments, tags, tagMatches);
    }

    private void closeConnection(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Category> getAllCategories() {
        PreparedStatement stmt = null;
        ArrayList<Category> results = new ArrayList<Category>();
        try {
            stmt = this.connection.prepareStatement("SELECT * FROM category ORDER BY category.ID");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt("ID");
                String name = rs.getString("Name");
                String color = rs.getString("Color");
                results.add(new Category(id, name, color));
            }
        }
        catch (SQLException e) {
            Logger.error(e);
        }
        finally {
            this.closeConnection(stmt);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<NormalPayment> getAllNormalPayments() {
        PreparedStatement stmt = null;
        ArrayList<NormalPayment> results = new ArrayList<NormalPayment>();
        try {
            stmt = this.connection.prepareStatement("SELECT * FROM payment;");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int resultID = rs.getInt("ID");
                String name = rs.getString("Name");
                int amount = rs.getInt("amount");
                String date = rs.getString("Date");
                int categoryID = rs.getInt("CategoryID");
                String description = rs.getString("Description");
                results.add(new NormalPayment(resultID, amount, date, categoryID, name, description));
            }
        }
        catch (SQLException e) {
            Logger.error(e);
        }
        finally {
            this.closeConnection(stmt);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<RepeatingPayment> getAllRepeatingPayments() {
        PreparedStatement stmt = null;
        ArrayList<RepeatingPayment> results = new ArrayList<RepeatingPayment>();
        try {
            stmt = this.connection.prepareStatement("SELECT * FROM repeating_payment;");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int resultID = rs.getInt("ID");
                String name = rs.getString("Name");
                String description = rs.getString("Description");
                int amount = rs.getInt("amount");
                String date = rs.getString("Date");
                int categoryID = rs.getInt("CategoryID");
                int repeatInterval = rs.getInt("RepeatInterval");
                String repeatEndDate = rs.getString("RepeatEndDate");
                int repeatMonthDay = rs.getInt("RepeatMonthDay");
                results.add(new RepeatingPayment(resultID, amount, date, categoryID, name, description, repeatInterval, repeatEndDate, repeatMonthDay));
            }
        }
        catch (SQLException e) {
            Logger.error(e);
        }
        finally {
            this.closeConnection(stmt);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Tag> getAllTags() {
        PreparedStatement stmt = null;
        ArrayList<Tag> results = new ArrayList<Tag>();
        try {
            stmt = this.connection.prepareStatement("SELECT * FROM tag;");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int resultID = rs.getInt("ID");
                String name = rs.getString("Name");
                results.add(new Tag(resultID, name));
            }
        }
        catch (SQLException e) {
            Logger.error(e);
        }
        finally {
            this.closeConnection(stmt);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<TagMatch> getAllTagMatches() {
        PreparedStatement stmt = null;
        ArrayList<TagMatch> results = new ArrayList<TagMatch>();
        try {
            stmt = this.connection.prepareStatement("SELECT * FROM tag_match;");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int tagID = rs.getInt("Tag_ID");
                int paymentID = rs.getInt("Payment_ID");
                int repeatingPaymentID = rs.getInt("RepeatingPayment_ID");
                results.add(new TagMatch(tagID, paymentID, repeatingPaymentID));
            }
        }
        catch (SQLException e) {
            Logger.error(e);
        }
        finally {
            this.closeConnection(stmt);
        }
        return results;
    }
}

