/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.category;

import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import spark.Request;
import spark.Response;
import spark.Spark;

public class CategoryUpdate
implements AdvancedRoute {
    private DatabaseHandler handler;

    public CategoryUpdate(DatabaseHandler handler) {
        this.handler = handler;
    }

    @Override
    public void before() {
        this.handler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        if (!(req.queryParams().contains("id") && req.queryParams().contains("name") && req.queryParams().contains("color"))) {
            Spark.halt(400, "Bad Request");
        }
        int id = -1;
        try {
            id = Integer.parseInt(req.queryMap("id").value());
            if (id < 0) {
                Spark.halt(400, "Bad Request");
            }
            try {
                this.handler.updateCategory(id, req.queryMap("name").value(), "#" + req.queryMap("color").value());
                return "";
            }
            catch (IllegalStateException ex) {
                Spark.halt(500, "Internal Server Error");
            }
        }
        catch (Exception e) {
            Spark.halt(400, "Bad Request");
        }
        return "";
    }

    @Override
    public void after() {
        this.handler.closeConnection();
    }
}

