/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.database;

import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.Settings;
import de.deadlocker8.budgetmasterserver.logic.Utils;
import de.deadlocker8.budgetmasterserver.logic.database.creator.DatabaseCreator;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import java.sql.Connection;
import java.sql.SQLException;
import logger.Logger;
import spark.Request;
import spark.Response;
import spark.Spark;

public class DatabaseDelete
implements AdvancedRoute {
    private DatabaseHandler handler;
    private Settings settings;

    public DatabaseDelete(DatabaseHandler handler, Settings settings) {
        this.handler = handler;
        this.settings = settings;
    }

    @Override
    public void before() {
        this.handler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        try {
            this.handler.deleteDatabase();
            Connection connection = Utils.getDatabaseConnection(this.settings);
            DatabaseCreator creator = Utils.getDatabaseCreator(connection, this.settings);
            creator.createTables();
            Logger.info("Successfully initialized database (" + this.settings.getDatabaseUrl() + this.settings.getDatabaseName() + ")");
            return "";
        }
        catch (ClassNotFoundException | IllegalStateException | SQLException ex) {
            Spark.halt(500, "Internal Server Error");
            return "";
        }
    }

    @Override
    public void after() {
        this.handler.closeConnection();
    }
}

