/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.rest;

import com.google.gson.Gson;
import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import spark.Request;
import spark.Response;
import spark.Spark;

public class RestGet
implements AdvancedRoute {
    private DatabaseHandler handler;
    private Gson gson;

    public RestGet(DatabaseHandler handler, Gson gson) {
        this.handler = handler;
        this.gson = gson;
    }

    @Override
    public void before() {
        this.handler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        if (!req.queryParams().contains("year") || !req.queryParams().contains("month")) {
            Spark.halt(400, "Bad Request");
        }
        int year = 0;
        int month = 0;
        try {
            year = Integer.parseInt(req.queryMap("year").value());
            month = Integer.parseInt(req.queryMap("month").value());
            if (year < 0 || month < 1 || month > 12) {
                Spark.halt(400, "Bad Request");
            }
            try {
                int rest = this.handler.getRestForAllPreviousMonths(year, month);
                return this.gson.toJson(rest);
            }
            catch (IllegalStateException ex) {
                Spark.halt(500, "Internal Server Error");
            }
        }
        catch (Exception e) {
            Spark.halt(400, "Bad Request");
        }
        return null;
    }

    @Override
    public void after() {
        this.handler.closeConnection();
    }
}

