/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.tag.match;

import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.taghandler.DatabaseTagHandler;
import de.deadlocker8.budgetmasterserver.server.updater.TagUpdater;
import spark.Request;
import spark.Response;
import spark.Spark;

public class TagMatchDeleteForRepeatingPayment
implements AdvancedRoute {
    private DatabaseTagHandler tagHandler;

    public TagMatchDeleteForRepeatingPayment(DatabaseTagHandler tagHandler) {
        this.tagHandler = tagHandler;
    }

    @Override
    public void before() {
        this.tagHandler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        if (!req.queryParams().contains("tagID") || !req.queryParams().contains("repeatingPaymentID")) {
            Spark.halt(400, "Bad Request");
        }
        try {
            int tagID = Integer.parseInt(req.queryMap("tagID").value());
            int repeatingPaymentID = Integer.parseInt(req.queryMap("repeatingPaymentID").value());
            if (tagID < 0 || repeatingPaymentID < 0) {
                Spark.halt(400, "Bad Request");
            }
            this.tagHandler.deleteTagMatchForRepeatingPayment(tagID, repeatingPaymentID);
            TagUpdater tagUpdater = new TagUpdater(this.tagHandler);
            tagUpdater.deleteTagsIfNotReferenced();
            return "";
        }
        catch (IllegalStateException ex) {
            Spark.halt(500, "Internal Server Error");
        }
        catch (Exception e) {
            Spark.halt(400, "Bad Request");
        }
        return "";
    }

    @Override
    public void after() {
        this.tagHandler.closeConnection();
    }
}

