/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.loadingbar.ui;

import de.deadlocker8.loadingbar.ui.CountdownTimer;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import tools.AlertGenerator;

public class Controller {
    @FXML
    private AnchorPane mainPane;
    @FXML
    private Label labelDescription;
    @FXML
    private Label labelTarget;
    @FXML
    private Label labelUser;
    @FXML
    private Label labelMessage;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private ProgressBar progressBarTarget;
    @FXML
    private StackPane stackPane;
    @FXML
    private Button buttonStop;
    private Stage stage;
    private Image icon = new Image("de/deadlocker8/loadingbar/resources/icon.png");
    private final ResourceBundle bundle = ResourceBundle.getBundle("de/deadlocker8/loadingbar/main/", Locale.GERMANY);
    private CountdownTimer timer;
    private int targetPercentage;
    private boolean swapped;
    private final String BACKGROUND_COLOR = "#333333";
    private boolean running;

    public void init(Stage stage) {
        this.stage = stage;
        this.mainPane.setStyle("-fx-background-color: #333333");
        this.stackPane.setStyle("-fx-background-color: derive(#333333, -60%)");
        this.progressBar.setStyle("-fx-accent: white;");
        this.labelDescription.setStyle("-fx-text-fill: white; -fx-font-size: 20; -fx-font-weight: bold;");
        this.labelTarget.setStyle("-fx-text-fill: white; -fx-font-size: 40; -fx-font-weight: bold;");
        this.labelUser.setStyle("-fx-text-fill: white; -fx-font-size: 30; -fx-font-weight: bold;");
        this.labelMessage.setStyle("-fx-text-fill: white; -fx-font-size: 30; -fx-font-weight: bold;");
        this.buttonStop.setStyle("-fx-background-color: transparent; -fx-border-color: white; -fx-border-width: 3; -fx-border-radius: 0; -fx-text-fill: white;");
        this.buttonStop.setText("START");
    }

    public void start() {
        if (this.swapped) {
            this.swapProgressBars();
            this.swapped = false;
        }
        this.running = true;
        this.buttonStop.setText("STOP");
        Random random = new Random();
        this.targetPercentage = 20 + random.nextInt(71);
        this.labelTarget.setText(String.valueOf(this.targetPercentage));
        this.labelUser.setText("");
        this.labelMessage.setText("");
        this.progressBarTarget.setProgress(0.0);
        this.progressBar.setProgress(0.0);
        this.timer = new CountdownTimer(4.0, this);
    }

    public void buttonStop() {
        if (this.running) {
            this.stop(this.timer.stop());
        } else {
            this.start();
        }
    }

    public void updateProgress(double value) {
        this.progressBar.setProgress(value);
    }

    private void swapProgressBars() {
        ObservableList workingCollection = FXCollections.observableArrayList((Collection)this.stackPane.getChildren());
        Collections.swap(workingCollection, 0, 1);
        this.stackPane.getChildren().setAll((Collection)workingCollection);
    }

    public void stop(double value) {
        this.running = false;
        this.buttonStop.setText("START");
        int userPercentage = (int)(value * 100.0);
        this.labelUser.setText(String.valueOf(userPercentage));
        this.progressBar.setProgress((double)userPercentage / 100.0);
        this.progressBarTarget.setProgress((double)this.targetPercentage / 100.0);
        this.progressBarTarget.setStyle("-fx-accent: red");
        if (userPercentage < this.targetPercentage) {
            this.swapped = true;
            this.swapProgressBars();
        }
        int difference = Math.abs(this.targetPercentage - userPercentage);
        switch (difference) {
            case 0: {
                this.labelMessage.setText("Awesome!");
                break;
            }
            case 1: {
                this.labelMessage.setText("Close One!");
                break;
            }
            case 2: {
                this.labelMessage.setText("Almost");
                break;
            }
            default: {
                this.labelMessage.setText("Missed by " + difference);
            }
        }
    }

    public Stage getStage() {
        return this.stage;
    }

    public void about() {
        AlertGenerator.showAboutAlert(this.bundle.getString("app.name"), this.bundle.getString("version.name"), this.bundle.getString("version.code"), this.bundle.getString("version.date"), this.bundle.getString("author"), this.icon, (Window)this.stage, null, false);
    }
}

