/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.loadingbar.ui;

import de.deadlocker8.loadingbar.ui.Controller;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;

public class CountdownTimer {
    private double count;
    private double time;
    private Controller controller;
    private Timer timer;
    private TimerTask task;

    public CountdownTimer(double seconds, Controller controller) {
        this.count = seconds;
        this.controller = controller;
        this.start();
    }

    public void start() {
        this.time = 0.0;
        this.task = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> {
                    try {
                        CountdownTimer.this.controller.updateProgress(CountdownTimer.this.time / CountdownTimer.this.count);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                if (CountdownTimer.this.time < CountdownTimer.this.count) {
                    CountdownTimer countdownTimer = CountdownTimer.this;
                    countdownTimer.time = countdownTimer.time + 0.01;
                }
                if (Math.abs(CountdownTimer.this.time - CountdownTimer.this.count) <= 1.0E-4) {
                    Platform.runLater(() -> CountdownTimer.this.controller.stop(1.0));
                    CountdownTimer.this.timer.cancel();
                }
            }
        };
        this.timer = new Timer();
        this.timer.schedule(this.task, 0L, 10L);
    }

    public double stop() {
        this.timer.cancel();
        this.timer.purge();
        return this.time / this.count;
    }
}

