/*
 * Decompiled with CFR 0.152.
 */
package logger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import logger.LogLevel;
import tools.PathUtils;

public class Logger {
    static SimpleDateFormat format = new SimpleDateFormat("dd.MM.YY - HH:mm:ss");
    public static LogLevel level;
    public static boolean fileOutput;
    public static File savePath;

    public static void log(LogLevel logLevel, String message) {
        if (level == null) {
            level = LogLevel.OFF;
        }
        String logMessage = Logger.createLogMessage(logLevel, message);
        switch (logLevel) {
            case INFO: {
                if (!level.equals((Object)LogLevel.ALL) && !level.equals((Object)LogLevel.INFO) && !level.equals((Object)LogLevel.NORMAL)) break;
                Logger.logToConsole(logMessage);
                if (!fileOutput) break;
                Logger.logToFile(logMessage);
                break;
            }
            case DEBUG: {
                if (!level.equals((Object)LogLevel.ALL) && !level.equals((Object)LogLevel.DEBUG)) break;
                Logger.logToConsole(logMessage);
                if (!fileOutput) break;
                Logger.logToFile(logMessage);
                break;
            }
            case ERROR: {
                if (!level.equals((Object)LogLevel.ALL) && !level.equals((Object)LogLevel.ERROR) && !level.equals((Object)LogLevel.NORMAL)) break;
                Logger.logErrorToConsole(logMessage);
                if (!fileOutput) break;
                Logger.logToFile(logMessage);
                break;
            }
        }
    }

    private static String createLogMessage(LogLevel logLevel, String message) {
        StackTraceElement element = Thread.currentThread().getStackTrace()[3];
        return "[" + (Object)((Object)logLevel) + "] - " + format.format(System.currentTimeMillis()) + " - " + element.getClassName() + "." + element.getMethodName() + ":" + element.getLineNumber() + "  -  " + message;
    }

    private static void logToConsole(String logMessage) {
        System.out.println(logMessage);
    }

    private static void logErrorToConsole(String logMessage) {
        System.err.println(logMessage);
    }

    private static void logToFile(String logMessage) {
        PathUtils.checkFolder(savePath.getParentFile());
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(savePath, true));
            out.write(logMessage);
            out.newLine();
            out.close();
        }
        catch (Exception e) {
            fileOutput = false;
            Logger.logErrorToConsole(Logger.createLogMessage(LogLevel.ERROR, "Can't log to file " + savePath + " FILEOUTPUT NOW DISABLED!"));
        }
    }

    public static void setLevel(LogLevel newLevel) {
        level = newLevel;
    }

    public static void enableFileOutput(File path) {
        fileOutput = true;
        savePath = path;
    }

    public static void disableFileOutput() {
        fileOutput = false;
    }

    public static void deleteLogfile() {
        savePath.delete();
    }

    public static String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
}

