/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.scene.paint.Color;

public class ConvertTo {
    public static String ConvertMillisToTime(long millis) {
        long sek = millis / 1000L % 60L;
        long min = millis / 60000L % 60L;
        long hour = millis / 3600000L;
        return String.valueOf(hour) + " h  " + min + " min  " + sek + " sek";
    }

    public static String ConvertSecondsToTime(long seconds) {
        long sek = seconds % 60L;
        long min = seconds / 60L % 60L;
        long hour = seconds / 3600L % 24L;
        return String.valueOf(hour) + " h " + min + " min " + sek + " sek";
    }

    public static String ConvertMillisToMinutesAndSeconds(long millis) {
        long sek = millis / 1000L % 60L;
        long min = millis / 1000L / 60L;
        return String.valueOf(min) + ":" + String.format("%02d", sek);
    }

    public static String ConvertMillisToDateAndTime(long millis) {
        Date date = new Date(millis);
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
        return formatter.format(date);
    }

    public static long ConvertTimestampToMillis(String time) {
        try {
            Timestamp timestamp = Timestamp.valueOf(time);
            return timestamp.getTime();
        }
        catch (IllegalArgumentException e) {
            System.err.println("Falsches Eingabeformat \nString muss folgende Struktur haben: yyyy-mm-dd hh:mm:ss[.SSSSSSSSS]");
            return 0L;
        }
    }

    public static String ConvertBytesToDecimalSize(long bytes) {
        long normal = bytes % 1000L;
        long kilo = bytes / 1000L % 1000L;
        long mega = bytes / 1000000L % 1000000L;
        return String.valueOf(mega) + " MB " + kilo + " KB " + normal;
    }

    public static String ConvertBytesToBinarySize(long bytes) {
        long normal = bytes % 1024L;
        long kilo = bytes / 1024L % 1024L;
        long mega = bytes / 0x100000L % 0x100000L;
        return String.valueOf(mega) + " MB " + kilo + " KB " + normal;
    }

    public static String toRGBHex(Color color) {
        return String.format("#%02X%02X%02X%02X", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), (int)(color.getOpacity() * 255.0));
    }
}

